/*
 * Decompiled with CFR 0.152.
 */
package dev.cbyrne.betterinject.injector.strategy;

import dev.cbyrne.betterinject.annotations.Arg;
import dev.cbyrne.betterinject.annotations.Local;
import dev.cbyrne.betterinject.utils.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public enum ArgumentHandlingStrategy {
    STRICT,
    LIGHT;

    private static final List<Class<? extends Annotation>> EXCEPTIONS;

    public static ArgumentHandlingStrategy fromMethod(MethodNode node, Type[] methodArgs) {
        if (methodArgs == null || methodArgs.length == 0) {
            return LIGHT;
        }
        boolean allAreAnnotatedWithArg = AnnotationUtils.allArgumentsAreAnnotatedWith(node, methodArgs, Arg.class, EXCEPTIONS);
        return allAreAnnotatedWithArg ? LIGHT : STRICT;
    }

    static {
        EXCEPTIONS = new ArrayList<Class<? extends Annotation>>();
        EXCEPTIONS.add(Local.class);
    }
}

