/*
 * Decompiled with CFR 0.152.
 */
package dev.cbyrne.betterinject.helpers;

import dev.cbyrne.betterinject.utils.CallbackInfoUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class CallbackInfoHelper {
    private int callbackInfoIndex = -1;
    private final boolean isCallbackInfoNeeded;
    private final boolean nextInsnIsReturn;

    public CallbackInfoHelper(boolean isCallbackInfoNeeded, boolean nextInsnIsReturn) {
        this.isCallbackInfoNeeded = isCallbackInfoNeeded;
        this.nextInsnIsReturn = nextInsnIsReturn;
    }

    public boolean isCallbackInfoNeeded() {
        return this.isCallbackInfoNeeded;
    }

    public boolean didGenerateCallbackInfo() {
        return this.callbackInfoIndex != -1;
    }

    public void generateCallbackInfo(InsnList instructions, Target target, boolean isMethodCancellable) {
        if (!this.isCallbackInfoNeeded() || this.didGenerateCallbackInfo()) {
            return;
        }
        this.callbackInfoIndex = target.allocateLocal();
        String callbackInfoClass = CallbackInfo.getCallInfoClassName((Type)target.returnType);
        String callbackInfoCtorDesc = "(Ljava/lang/String;Z)V";
        int returnTypeLocal = target.allocateLocal();
        if (this.nextInsnIsReturn && !target.returnType.equals((Object)Type.VOID_TYPE)) {
            int dupCode = target.returnType.getSize() == 1 ? 89 : 92;
            instructions.add((AbstractInsnNode)new InsnNode(dupCode));
            instructions.add((AbstractInsnNode)new VarInsnNode(target.returnType.getOpcode(54), returnTypeLocal));
        }
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, callbackInfoClass));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new LdcInsnNode((Object)target.method.name));
        instructions.add((AbstractInsnNode)new InsnNode(isMethodCancellable ? 4 : 3));
        if (this.nextInsnIsReturn && !target.returnType.equals((Object)Type.VOID_TYPE)) {
            instructions.add((AbstractInsnNode)new VarInsnNode(target.returnType.getOpcode(21), returnTypeLocal));
            callbackInfoCtorDesc = CallbackInfoUtils.constructorDescriptor(target.returnType);
        }
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, callbackInfoClass, "<init>", callbackInfoCtorDesc, false));
        target.addLocalVariable(this.callbackInfoIndex, "callbackInfo" + this.callbackInfoIndex, "L" + callbackInfoClass + ";");
        instructions.add((AbstractInsnNode)new VarInsnNode(58, this.callbackInfoIndex));
    }

    public void pushCallbackInfoIfRequired(InsnList instructions) {
        if (!this.isCallbackInfoNeeded() || !this.didGenerateCallbackInfo()) {
            return;
        }
        instructions.add((AbstractInsnNode)new VarInsnNode(25, this.callbackInfoIndex));
    }

    public void wrapInCancellationCheck(InsnList instructions, Target target) {
        if (!this.isCallbackInfoNeeded || !this.didGenerateCallbackInfo()) {
            return;
        }
        String callbackInfoClass = CallbackInfo.getCallInfoClassName((Type)target.returnType);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, this.callbackInfoIndex));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, callbackInfoClass, "isCancelled", "()Z", false));
        LabelNode ifNotCancelled = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(153, ifNotCancelled));
        if (target.returnType == Type.VOID_TYPE) {
            instructions.add((AbstractInsnNode)new InsnNode(177));
        } else {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, this.callbackInfoIndex));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, callbackInfoClass, CallbackInfoUtils.returnFunctionName(target.returnType), CallbackInfoUtils.returnFunctionDescriptor(target.returnType), false));
            if (target.returnType.getSort() >= 9) {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, target.returnType.getInternalName()));
            }
            instructions.add((AbstractInsnNode)new InsnNode(target.returnType.getOpcode(172)));
        }
        instructions.add((AbstractInsnNode)ifNotCancelled);
    }
}

