/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import lombok.NonNull;
import me.x150.renderer.util.FastMStack;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RendererUtils {
    @ApiStatus.Internal
    public static final Matrix4f lastProjMat = new Matrix4f();
    @ApiStatus.Internal
    public static final Matrix4f lastModMat = new Matrix4f();
    @ApiStatus.Internal
    public static final Matrix4f lastWorldSpaceMatrix = new Matrix4f();
    private static final FastMStack empty = new FastMStack();
    private static final class_310 client = class_310.method_1551();
    private static final char RND_START = 'a';
    private static final char RND_END = 'z';
    private static final Random RND = new Random();

    public static void setupRender() {
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void endRender() {
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.depthFunc((int)515);
    }

    public static int lerp(int from, int to, double delta) {
        return (int)Math.floor((double)from + (double)(to - from) * class_3532.method_15350((double)delta, (double)0.0, (double)1.0));
    }

    public static double lerp(double from, double to, double delta) {
        return from + (to - from) * class_3532.method_15350((double)delta, (double)0.0, (double)1.0);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static Color lerp(@NonNull Color a, @NonNull Color b, double c) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return new Color(RendererUtils.lerp(a.getRed(), b.getRed(), c), RendererUtils.lerp(a.getGreen(), b.getGreen(), c), RendererUtils.lerp(a.getBlue(), b.getBlue(), c), RendererUtils.lerp(a.getAlpha(), b.getAlpha(), c));
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    public static Color modify(@NonNull Color original, int redOverwrite, int greenOverwrite, int blueOverwrite, int alphaOverwrite) {
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        return new Color(redOverwrite == -1 ? original.getRed() : redOverwrite, greenOverwrite == -1 ? original.getGreen() : greenOverwrite, blueOverwrite == -1 ? original.getBlue() : blueOverwrite, alphaOverwrite == -1 ? original.getAlpha() : alphaOverwrite);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static class_243 translateVec3dWithMatrixStack(@NonNull class_4587 stack, @NonNull class_243 in) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        Matrix4f matrix = stack.method_23760().method_23761();
        Vector4f vec = new Vector4f((float)in.field_1352, (float)in.field_1351, (float)in.field_1350, 1.0f);
        vec.mul((Matrix4fc)matrix);
        return new class_243((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public static void registerBufferedImageTexture(@NonNull class_2960 i, @NonNull BufferedImage bi) {
        if (i == null) {
            throw new NullPointerException("i is marked non-null but is null");
        }
        if (bi == null) {
            throw new NullPointerException("bi is marked non-null but is null");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "png", out);
            byte[] bytes = out.toByteArray();
            ByteBuffer data = BufferUtils.createByteBuffer((int)bytes.length).put(bytes);
            data.flip();
            class_1043 tex = new class_1043(class_1011.method_4324((ByteBuffer)data));
            class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(i, (class_1044)tex));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class_4587 getEmptyMatrixStack() {
        if (!empty.method_22911()) {
            throw new IllegalStateException("Supposed \"empty\" stack is not actually empty; someone does not clean up after themselves.");
        }
        empty.method_34426();
        return empty;
    }

    @Contract(value="-> new")
    public static class_243 getCrosshairVector() {
        class_4184 camera = RendererUtils.client.field_1773.method_19418();
        float pi = (float)Math.PI;
        float yawRad = (float)Math.toRadians(-camera.method_19330());
        float pitchRad = (float)Math.toRadians(-camera.method_19329());
        float f1 = class_3532.method_15362((float)(yawRad - pi));
        float f2 = class_3532.method_15374((float)(yawRad - pi));
        float f3 = -class_3532.method_15362((float)pitchRad);
        float f4 = class_3532.method_15374((float)pitchRad);
        return new class_243((double)(f2 * f3), (double)f4, (double)(f1 * f3)).method_1019(camera.method_19326());
    }

    @Contract(value="_ -> new", pure=true)
    public static class_243 worldSpaceToScreenSpace(@NonNull class_243 pos) {
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        class_4184 camera = RendererUtils.client.method_1561().field_4686;
        int displayHeight = client.method_22683().method_4507();
        int[] viewport = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewport);
        Vector3f target = new Vector3f();
        double deltaX = pos.field_1352 - camera.method_19326().field_1352;
        double deltaY = pos.field_1351 - camera.method_19326().field_1351;
        double deltaZ = pos.field_1350 - camera.method_19326().field_1350;
        Vector4f transformedCoordinates = new Vector4f((float)deltaX, (float)deltaY, (float)deltaZ, 1.0f).mul((Matrix4fc)lastWorldSpaceMatrix);
        Matrix4f matrixProj = new Matrix4f((Matrix4fc)lastProjMat);
        Matrix4f matrixModel = new Matrix4f((Matrix4fc)lastModMat);
        matrixProj.mul((Matrix4fc)matrixModel).project(transformedCoordinates.x(), transformedCoordinates.y(), transformedCoordinates.z(), viewport, target);
        return new class_243((double)target.x / client.method_22683().method_4495(), (double)((float)displayHeight - target.y) / client.method_22683().method_4495(), (double)target.z);
    }

    public static boolean screenSpaceCoordinateIsVisible(class_243 pos) {
        return pos != null && pos.field_1350 > -1.0 && pos.field_1350 < 1.0;
    }

    @Contract(value="_,_,_ -> new", pure=true)
    public static class_243 screenSpaceToWorldSpace(double x, double y, double d) {
        class_4184 camera = RendererUtils.client.method_1561().field_4686;
        int displayHeight = client.method_22683().method_4502();
        int displayWidth = client.method_22683().method_4486();
        int[] viewport = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewport);
        Vector3f target = new Vector3f();
        Matrix4f matrixProj = new Matrix4f((Matrix4fc)lastProjMat);
        Matrix4f matrixModel = new Matrix4f((Matrix4fc)lastModMat);
        matrixProj.mul((Matrix4fc)matrixModel).mul((Matrix4fc)lastWorldSpaceMatrix).unproject((float)x / (float)displayWidth * (float)viewport[2], (float)((double)displayHeight - y) / (float)displayHeight * (float)viewport[3], (float)d, viewport, target);
        return new class_243((double)target.x, (double)target.y, (double)target.z).method_1019(camera.method_19326());
    }

    public static int getGuiScale() {
        return (int)class_310.method_1551().method_22683().method_4495();
    }

    private static String randomString(int length) {
        return IntStream.range(0, length).mapToObj(operand -> String.valueOf((char)RND.nextInt(97, 123))).collect(Collectors.joining());
    }

    @Contract(value="-> new", pure=true)
    public static class_2960 randomIdentifier() {
        return new class_2960("renderer", "temp/" + RendererUtils.randomString(32));
    }
}

