/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.util;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.Range;

public class Colors {
    public static int ARGBToInt(@Range(from=0L, to=255L) int r, @Range(from=0L, to=255L) int g, @Range(from=0L, to=255L) int b, @Range(from=0L, to=255L) int a) {
        Preconditions.checkArgument((boolean)Colors.validateColorRange(r), (Object)("Expected r to be 0-255, received " + r));
        Preconditions.checkArgument((boolean)Colors.validateColorRange(g), (Object)("Expected g to be 0-255, received " + g));
        Preconditions.checkArgument((boolean)Colors.validateColorRange(b), (Object)("Expected b to be 0-255, received " + b));
        Preconditions.checkArgument((boolean)Colors.validateColorRange(a), (Object)("Expected a to be 0-255, received " + a));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int RGBAToInt(@Range(from=0L, to=255L) int r, @Range(from=0L, to=255L) int g, @Range(from=0L, to=255L) int b, @Range(from=0L, to=255L) int a) {
        Preconditions.checkArgument((boolean)Colors.validateColorRange(r), (Object)("Expected r to be 0-255, received " + r));
        Preconditions.checkArgument((boolean)Colors.validateColorRange(g), (Object)("Expected g to be 0-255, received " + g));
        Preconditions.checkArgument((boolean)Colors.validateColorRange(b), (Object)("Expected b to be 0-255, received " + b));
        Preconditions.checkArgument((boolean)Colors.validateColorRange(a), (Object)("Expected a to be 0-255, received " + a));
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static int[] RGBAIntToRGBA(int in) {
        int red = in >> 24 & 0xFF;
        int green = in >> 16 & 0xFF;
        int blue = in >> 8 & 0xFF;
        int alpha = in & 0xFF;
        return new int[]{red, green, blue, alpha};
    }

    public static int[] ARGBIntToRGBA(int in) {
        int alpha = in >> 24 & 0xFF;
        int red = in >> 16 & 0xFF;
        int green = in >> 8 & 0xFF;
        int blue = in & 0xFF;
        return new int[]{red, green, blue, alpha};
    }

    public static int[] RGBIntToRGB(int in) {
        int red = in >> 16 & 0xFF;
        int green = in >> 8 & 0xFF;
        int blue = in & 0xFF;
        return new int[]{red, green, blue};
    }

    public static float[] intArrayToFloatArray(int[] in) {
        Preconditions.checkArgument((in.length == 4 ? 1 : 0) != 0, (Object)("Expected int[] of size 4, got " + in.length));
        for (int i = 0; i < in.length; ++i) {
            Preconditions.checkArgument((boolean)Colors.validateColorRange(in[i]), (Object)("Expected in[" + i + "] to be 0-255, got " + in[i]));
        }
        return new float[]{(float)in[0] / 255.0f, (float)in[1] / 255.0f, (float)in[2] / 255.0f, (float)in[3] / 255.0f};
    }

    private static boolean validateColorRange(int in) {
        return in >= 0 && in <= 255;
    }
}

