/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.x150.renderer.util.AlphaOverride;
import me.x150.renderer.util.BufferUtils;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public class Renderer3d {
    static final List<FadingBlock> fades = new CopyOnWriteArrayList<FadingBlock>();
    private static final class_310 client = class_310.method_1551();
    private static boolean renderThroughWalls = false;

    public static void renderThroughWalls() {
        renderThroughWalls = true;
    }

    public static void stopRenderThroughWalls() {
        renderThroughWalls = false;
    }

    public static boolean rendersThroughWalls() {
        return renderThroughWalls;
    }

    private static void setupRender() {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)(renderThroughWalls ? 519 : 515));
    }

    private static void endRender() {
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    static float transformColor(float f) {
        return AlphaOverride.compute(f);
    }

    public static void renderFadingBlock(Color outlineColor, Color fillColor, class_243 start, class_243 dimensions, long lifeTimeMs) {
        FadingBlock fb = new FadingBlock(outlineColor, fillColor, start, dimensions, System.currentTimeMillis(), lifeTimeMs);
        fades.removeIf(fadingBlock -> fadingBlock.start.equals((Object)start) && fadingBlock.dimensions.equals((Object)dimensions));
        fades.add(fb);
    }

    @ApiStatus.Internal
    public static void renderFadingBlocks(class_4587 stack) {
        fades.removeIf(FadingBlock::isDead);
        for (FadingBlock fade : fades) {
            if (fade == null) continue;
            long lifetimeLeft = fade.getLifeTimeLeft();
            double progress = (double)lifetimeLeft / (double)fade.lifeTime;
            progress = class_3532.method_15350((double)progress, (double)0.0, (double)1.0);
            double ip = 1.0 - progress;
            Color out = Renderer3d.modifyColor(fade.outline, -1, -1, -1, (int)((double)fade.outline.getAlpha() * progress));
            Color fill = Renderer3d.modifyColor(fade.fill, -1, -1, -1, (int)((double)fade.fill.getAlpha() * progress));
            Renderer3d.renderEdged(stack, fill, out, fade.start.method_1019(new class_243(0.2, 0.2, 0.2).method_1021(ip)), fade.dimensions.method_1020(new class_243(0.4, 0.4, 0.4).method_1021(ip)));
        }
    }

    private static class_243 transformVec3d(class_243 in) {
        class_4184 camera = Renderer3d.client.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        return in.method_1020(camPos);
    }

    static float[] getColor(Color c) {
        return new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, Renderer3d.transformColor((float)c.getAlpha() / 255.0f)};
    }

    private static void useBuffer(class_293.class_5596 mode, class_293 format, Supplier<class_5944> shader, Consumer<class_287> runner) {
        class_289 t = class_289.method_1348();
        class_287 bb = t.method_1349();
        bb.method_1328(mode, format);
        runner.accept(bb);
        Renderer3d.setupRender();
        RenderSystem.setShader(shader);
        BufferUtils.draw(bb);
        Renderer3d.endRender();
    }

    public static void renderOutline(class_4587 stack, Color color, class_243 start, class_243 dimensions) {
        Matrix4f m = stack.method_23760().method_23761();
        Renderer3d.genericAABBRender(class_293.class_5596.field_29344, class_290.field_1576, class_757::method_34540, m, start, dimensions, color, (buffer, x1, y1, z1, x2, y2, z2, red, green, blue, alpha, matrix) -> {
            buffer.method_22918(matrix, x1, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(red, green, blue, alpha).method_1344();
        });
    }

    public static void renderEdged(class_4587 stack, Color colorFill, Color colorOutline, class_243 start, class_243 dimensions) {
        Matrix4f matrix = stack.method_23760().method_23761();
        float[] fill = Renderer3d.getColor(colorFill);
        float[] outline = Renderer3d.getColor(colorOutline);
        class_243 vec3d = Renderer3d.transformVec3d(start);
        class_243 end = vec3d.method_1019(dimensions);
        float x1 = (float)vec3d.field_1352;
        float y1 = (float)vec3d.field_1351;
        float z1 = (float)vec3d.field_1350;
        float x2 = (float)end.field_1352;
        float y2 = (float)end.field_1351;
        float z2 = (float)end.field_1350;
        float redFill = fill[0];
        float greenFill = fill[1];
        float blueFill = fill[2];
        float alphaFill = fill[3];
        float redOutline = outline[0];
        float greenOutline = outline[1];
        float blueOutline = outline[2];
        float alphaOutline = outline[3];
        Renderer3d.useBuffer(class_293.class_5596.field_27382, class_290.field_1576, class_757::method_34540, buffer -> {
            buffer.method_22918(matrix, x1, y2, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(redFill, greenFill, blueFill, alphaFill).method_1344();
        });
        Renderer3d.useBuffer(class_293.class_5596.field_29344, class_290.field_1576, class_757::method_34540, buffer -> {
            buffer.method_22918(matrix, x1, y1, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(redOutline, greenOutline, blueOutline, alphaOutline).method_1344();
        });
    }

    private static void genericAABBRender(class_293.class_5596 mode, class_293 format, Supplier<class_5944> shader, Matrix4f stack, class_243 start, class_243 dimensions, Color color, RenderAction action) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = Renderer3d.transformColor((float)color.getAlpha() / 255.0f);
        class_243 vec3d = Renderer3d.transformVec3d(start);
        class_243 end = vec3d.method_1019(dimensions);
        float x1 = (float)vec3d.field_1352;
        float y1 = (float)vec3d.field_1351;
        float z1 = (float)vec3d.field_1350;
        float x2 = (float)end.field_1352;
        float y2 = (float)end.field_1351;
        float z2 = (float)end.field_1350;
        Renderer3d.useBuffer(mode, format, shader, bufferBuilder -> action.run((class_287)bufferBuilder, x1, y1, z1, x2, y2, z2, red, green, blue, alpha, stack));
    }

    public static void renderFilled(class_4587 stack, Color color, class_243 start, class_243 dimensions) {
        Matrix4f s = stack.method_23760().method_23761();
        Renderer3d.genericAABBRender(class_293.class_5596.field_27382, class_290.field_1576, class_757::method_34540, s, start, dimensions, color, (buffer, x1, y1, z1, x2, y2, z2, red, green, blue, alpha, matrix) -> {
            buffer.method_22918(matrix, x1, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y2, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z1).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x2, y1, z2).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z2).method_22915(red, green, blue, alpha).method_1344();
        });
    }

    public static void renderLine(class_4587 matrices, Color color, class_243 start, class_243 end) {
        Matrix4f s = matrices.method_23760().method_23761();
        Renderer3d.genericAABBRender(class_293.class_5596.field_29344, class_290.field_1576, class_757::method_34540, s, start, end.method_1020(start), color, (buffer, x, y, z, x1, y1, z1, red, green, blue, alpha, matrix) -> {
            buffer.method_22918(matrix, x, y, z).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(matrix, x1, y1, z1).method_22915(red, green, blue, alpha).method_1344();
        });
    }

    public static Color modifyColor(Color original, int redOverwrite, int greenOverwrite, int blueOverwrite, int alphaOverwrite) {
        return new Color(redOverwrite == -1 ? original.getRed() : redOverwrite, greenOverwrite == -1 ? original.getGreen() : greenOverwrite, blueOverwrite == -1 ? original.getBlue() : blueOverwrite, alphaOverwrite == -1 ? original.getAlpha() : alphaOverwrite);
    }

    record FadingBlock(Color outline, Color fill, class_243 start, class_243 dimensions, long created, long lifeTime) {
        long getLifeTimeLeft() {
            return Math.max(0L, this.created - System.currentTimeMillis() + this.lifeTime);
        }

        boolean isDead() {
            return this.getLifeTimeLeft() == 0L;
        }
    }

    static interface RenderAction {
        public void run(class_287 var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, Matrix4f var12);
    }
}

