/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.render;

import java.util.Stack;
import me.x150.renderer.render.Renderer2d;
import me.x150.renderer.util.Rectangle;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class ClipStack {
    static final Stack<Rectangle> clipStack = new Stack();

    public static void addWindow(class_4587 stack, Rectangle rect) {
        Matrix4f matrix = stack.method_23760().method_23761();
        Vector4f start = new Vector4f((float)rect.getX(), (float)rect.getY(), 0.0f, 1.0f);
        Vector4f end = new Vector4f((float)rect.getX1(), (float)rect.getY1(), 0.0f, 1.0f);
        start.mul((Matrix4fc)matrix);
        end.mul((Matrix4fc)matrix);
        double x0 = start.x();
        double y0 = start.y();
        double x1 = end.x();
        double y1 = end.y();
        Rectangle transformed = new Rectangle(x0, y0, x1, y1);
        if (clipStack.empty()) {
            clipStack.push(transformed);
            Renderer2d.beginScissor(transformed.getX(), transformed.getY(), transformed.getX1(), transformed.getY1());
        } else {
            Rectangle lastClip = clipStack.peek();
            double lx0 = lastClip.getX();
            double ly0 = lastClip.getY();
            double lx1 = lastClip.getX1();
            double ly1 = lastClip.getY1();
            double nx0 = class_3532.method_15350((double)transformed.getX(), (double)lx0, (double)lx1);
            double ny0 = class_3532.method_15350((double)transformed.getY(), (double)ly0, (double)ly1);
            double nx1 = class_3532.method_15350((double)transformed.getX1(), (double)nx0, (double)lx1);
            double ny1 = class_3532.method_15350((double)transformed.getY1(), (double)ny0, (double)ly1);
            clipStack.push(new Rectangle(nx0, ny0, nx1, ny1));
            Renderer2d.beginScissor(nx0, ny0, nx1, ny1);
        }
    }

    public static void use(class_4587 stack, Rectangle clippingRect, Runnable renderAction) {
        ClipStack.addWindow(stack, clippingRect);
        renderAction.run();
        ClipStack.popWindow();
    }

    public static void popWindow() {
        clipStack.pop();
        if (clipStack.empty()) {
            Renderer2d.endScissor();
        } else {
            Rectangle r = clipStack.peek();
            Renderer2d.beginScissor(r.getX(), r.getY(), r.getX1(), r.getY1());
        }
    }

    public static void renderOutsideClipStack(Runnable e) {
        if (clipStack.empty()) {
            e.run();
        } else {
            Renderer2d.endScissor();
            e.run();
            Rectangle r = clipStack.peek();
            Renderer2d.beginScissor(r.getX(), r.getY(), r.getX1(), r.getY1());
        }
    }
}

