/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.font;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.chars.Char2IntArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Font;
import java.io.Closeable;
import java.util.List;
import me.x150.renderer.font.Glyph;
import me.x150.renderer.font.GlyphMap;
import me.x150.renderer.util.BufferUtils;
import me.x150.renderer.util.Colors;
import me.x150.renderer.util.RendererUtils;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class FontRenderer
implements Closeable {
    private static final Char2IntArrayMap colorCodes = new Char2IntArrayMap(){
        {
            this.put('0', 0);
            this.put('1', 170);
            this.put('2', 43520);
            this.put('3', 43690);
            this.put('4', 0xAA0000);
            this.put('5', 0xAA00AA);
            this.put('6', 0xFFAA00);
            this.put('7', 0xAAAAAA);
            this.put('8', 0x555555);
            this.put('9', 0x5555FF);
            this.put('A', 0x55FF55);
            this.put('B', 0x55FFFF);
            this.put('C', 0xFF5555);
            this.put('D', 0xFF55FF);
            this.put('E', 0xFFFF55);
            this.put('F', 0xFFFFFF);
        }
    };
    private static final int BLOCK_SIZE = 256;
    private static final Object2ObjectArrayMap<class_2960, ObjectList<DrawEntry>> GLYPH_PAGE_CACHE = new Object2ObjectArrayMap();
    private final float originalSize;
    private final ObjectList<GlyphMap> maps = new ObjectArrayList();
    private final Char2ObjectArrayMap<Glyph> allGlyphs = new Char2ObjectArrayMap();
    private int scaleMul = 0;
    private Font[] fonts;
    private int previousGameScale = -1;

    public FontRenderer(Font[] fonts, float sizePx) {
        Preconditions.checkArgument((fonts.length > 0 ? 1 : 0) != 0, (Object)"fonts.length == 0");
        this.originalSize = sizePx;
        this.init(fonts, sizePx);
    }

    private static int floorNearestMulN(int x, int n) {
        return n * (int)Math.floor((double)x / (double)n);
    }

    public static String stripControlCodes(String text) {
        char[] chars = text.toCharArray();
        StringBuilder f = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            f.append(c);
        }
        return f.toString();
    }

    private void sizeCheck() {
        int gs = RendererUtils.getGuiScale();
        if (gs != this.previousGameScale) {
            this.close();
            this.init(this.fonts, this.originalSize);
        }
    }

    private void init(Font[] fonts, float sizePx) {
        this.scaleMul = this.previousGameScale = RendererUtils.getGuiScale();
        this.fonts = new Font[fonts.length];
        for (int i = 0; i < fonts.length; ++i) {
            this.fonts[i] = fonts[i].deriveFont(sizePx * (float)this.scaleMul);
        }
    }

    private GlyphMap generateMap(char from, char to) {
        GlyphMap gm = new GlyphMap(from, to, this.fonts, RendererUtils.randomIdentifier());
        this.maps.add((Object)gm);
        return gm;
    }

    private Glyph locateGlyph0(char glyph) {
        for (GlyphMap map : this.maps) {
            if (!map.contains(glyph)) continue;
            return map.getGlyph(glyph);
        }
        int base = FontRenderer.floorNearestMulN(glyph, 256);
        GlyphMap glyphMap = this.generateMap((char)base, (char)(base + 256));
        return glyphMap.getGlyph(glyph);
    }

    private Glyph locateGlyph1(char glyph) {
        return (Glyph)this.allGlyphs.computeIfAbsent(glyph, this::locateGlyph0);
    }

    public void drawString(class_4587 stack, String s, float x, float y, float r, float g, float b, float a) {
        this.sizeCheck();
        float r2 = r;
        float g2 = g;
        float b2 = b;
        stack.method_22903();
        stack.method_46416(x, y, 0.0f);
        stack.method_22905(1.0f / (float)this.scaleMul, 1.0f / (float)this.scaleMul, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        RenderSystem.setShader(class_757::method_34543);
        class_287 bb = class_289.method_1348().method_1349();
        Matrix4f mat = stack.method_23760().method_23761();
        char[] chars = s.toCharArray();
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        boolean inSel = false;
        int lineStart = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (inSel) {
                inSel = false;
                char c1 = Character.toUpperCase(c);
                if (colorCodes.containsKey(c1)) {
                    int ii = colorCodes.get(c1);
                    int[] col = Colors.RGBIntToRGB(ii);
                    r2 = (float)col[0] / 255.0f;
                    g2 = (float)col[1] / 255.0f;
                    b2 = (float)col[2] / 255.0f;
                    continue;
                }
                if (c1 != 'R') continue;
                r2 = r;
                g2 = g;
                b2 = b;
                continue;
            }
            if (c == '\u00a7') {
                inSel = true;
                continue;
            }
            if (c == '\n') {
                yOffset += this.getStringHeight(s.substring(lineStart, i)) * (float)this.scaleMul;
                xOffset = 0.0f;
                lineStart = i + 1;
                continue;
            }
            Glyph glyph = this.locateGlyph1(c);
            if (glyph.value() != ' ') {
                class_2960 i1 = glyph.owner().bindToTexture;
                DrawEntry entry = new DrawEntry(xOffset, yOffset, r2, g2, b2, glyph);
                ((ObjectList)GLYPH_PAGE_CACHE.computeIfAbsent((Object)i1, integer -> new ObjectArrayList())).add((Object)entry);
            }
            xOffset += (float)glyph.width();
        }
        for (class_2960 identifier : GLYPH_PAGE_CACHE.keySet()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
            List objects = (List)GLYPH_PAGE_CACHE.get((Object)identifier);
            bb.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            for (DrawEntry object : objects) {
                float xo = object.atX;
                float yo = object.atY;
                float cr = object.r;
                float cg = object.g;
                float cb = object.b;
                Glyph glyph = object.toDraw;
                GlyphMap owner = glyph.owner();
                float w = glyph.width();
                float h = glyph.height();
                float u1 = (float)glyph.u() / (float)owner.width;
                float v1 = (float)glyph.v() / (float)owner.height;
                float u2 = (float)(glyph.u() + glyph.width()) / (float)owner.width;
                float v2 = (float)(glyph.v() + glyph.height()) / (float)owner.height;
                bb.method_22918(mat, xo + 0.0f, yo + h, 0.0f).method_22913(u1, v2).method_22915(cr, cg, cb, a).method_1344();
                bb.method_22918(mat, xo + w, yo + h, 0.0f).method_22913(u2, v2).method_22915(cr, cg, cb, a).method_1344();
                bb.method_22918(mat, xo + w, yo + 0.0f, 0.0f).method_22913(u2, v1).method_22915(cr, cg, cb, a).method_1344();
                bb.method_22918(mat, xo + 0.0f, yo + 0.0f, 0.0f).method_22913(u1, v1).method_22915(cr, cg, cb, a).method_1344();
            }
            BufferUtils.draw(bb);
        }
        stack.method_22909();
        GLYPH_PAGE_CACHE.clear();
    }

    public void drawCenteredString(class_4587 stack, String s, float x, float y, float r, float g, float b, float a) {
        this.drawString(stack, s, x - this.getStringWidth(s) / 2.0f, y, r, g, b, a);
    }

    public float getStringWidth(String text) {
        char[] c = FontRenderer.stripControlCodes(text).toCharArray();
        float currentLine = 0.0f;
        float maxPreviousLines = 0.0f;
        for (char c1 : c) {
            if (c1 == '\n') {
                maxPreviousLines = Math.max(currentLine, maxPreviousLines);
                currentLine = 0.0f;
                continue;
            }
            Glyph glyph = this.locateGlyph1(c1);
            currentLine += (float)glyph.width() / (float)this.scaleMul;
        }
        return Math.max(currentLine, maxPreviousLines);
    }

    public float getStringHeight(String text) {
        char[] c = FontRenderer.stripControlCodes(text).toCharArray();
        if (c.length == 0) {
            c = new char[]{' '};
        }
        float currentLine = 0.0f;
        float previous = 0.0f;
        for (char c1 : c) {
            if (c1 == '\n') {
                if (currentLine == 0.0f) {
                    currentLine = (float)this.locateGlyph1(' ').height() / (float)this.scaleMul;
                }
                previous += currentLine;
                currentLine = 0.0f;
                continue;
            }
            Glyph glyph = this.locateGlyph1(c1);
            currentLine = Math.max((float)glyph.height() / (float)this.scaleMul, currentLine);
        }
        return currentLine + previous;
    }

    @Override
    public void close() {
        for (GlyphMap map : this.maps) {
            map.destroy();
        }
        this.maps.clear();
        this.allGlyphs.clear();
    }

    record DrawEntry(float atX, float atY, float r, float g, float b, Glyph toDraw) {
    }
}

