/*
 * Decompiled with CFR 0.152.
 */
package marcono1234.gson.recordadapter;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import marcono1234.gson.recordadapter.ComponentTypeHelper;
import marcono1234.gson.recordadapter.JsonAdapterCreator;
import marcono1234.gson.recordadapter.RecordComponentNamingStrategy;
import marcono1234.gson.recordadapter.RecordTypeAdapterException;
import marcono1234.gson.recordadapter.RuntimeTypeTypeAdapter;

public class RecordTypeAdapterFactory
implements TypeAdapterFactory {
    private static final boolean DEFAULT_SERIALIZE_RUNTIME_COMPONENT_TYPES = false;
    private static final boolean DEFAULT_ALLOW_MISSING_COMPONENT_VALUES = false;
    private static final boolean DEFAULT_ALLOW_UNKNOWN_PROPERTIES = true;
    private static final boolean DEFAULT_ALLOW_DUPLICATE_COMPONENT_VALUES = false;
    private static final boolean DEFAULT_ALLOW_JSON_NULL_FOR_PRIMITIVES = false;
    private static final RecordComponentNamingStrategy DEFAULT_NAMING_STRATEGY = RecordComponentNamingStrategy.IDENTITY;
    private static final JsonAdapterCreator DEFAULT_JSON_ADAPTER_CREATOR = JsonAdapterCreator.DEFAULT_CONSTRUCTOR_INVOKER;
    public static final RecordTypeAdapterFactory DEFAULT = RecordTypeAdapterFactory.builder().create();
    private final boolean serializeRuntimeComponentTypes;
    private final boolean allowMissingComponentValues;
    private final boolean allowUnknownProperties;
    private final boolean allowDuplicateComponentValues;
    private final boolean allowJsonNullForPrimitives;
    private final RecordComponentNamingStrategy namingStrategy;
    private final List<JsonAdapterCreator> jsonAdapterCreators;
    private static final Byte DEFAULT_BYTE = 0;
    private static final Short DEFAULT_SHORT = 0;
    private static final Integer DEFAULT_INT = 0;
    private static final Long DEFAULT_LONG = 0L;
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    private static final Double DEFAULT_DOUBLE = 0.0;
    private static final Character DEFAULT_CHAR = Character.valueOf('\u0000');

    @Deprecated
    public RecordTypeAdapterFactory() {
        this(false, false, true, false, false, DEFAULT_NAMING_STRATEGY, List.of(DEFAULT_JSON_ADAPTER_CREATOR));
    }

    public static Builder builder() {
        return new Builder();
    }

    private RecordTypeAdapterFactory(boolean serializeRuntimeComponentTypes, boolean allowMissingComponentValues, boolean allowUnknownProperties, boolean allowDuplicateComponentValues, boolean allowJsonNullForPrimitives, RecordComponentNamingStrategy namingStrategy, List<JsonAdapterCreator> jsonAdapterCreators) {
        this.serializeRuntimeComponentTypes = serializeRuntimeComponentTypes;
        this.allowMissingComponentValues = allowMissingComponentValues;
        this.allowUnknownProperties = allowUnknownProperties;
        this.allowDuplicateComponentValues = allowDuplicateComponentValues;
        this.allowJsonNullForPrimitives = allowJsonNullForPrimitives;
        this.namingStrategy = namingStrategy;
        this.jsonAdapterCreators = jsonAdapterCreators;
        assert (!jsonAdapterCreators.isEmpty());
    }

    private static Field getComponentField(RecordComponent component) throws RecordTypeAdapterException {
        try {
            return component.getDeclaringRecord().getDeclaredField(component.getName());
        }
        catch (NoSuchFieldException e) {
            throw new RecordTypeAdapterException("Unexpected: Failed finding component field for " + component);
        }
    }

    private ComponentNames getComponentNames(RecordComponent component) throws RecordTypeAdapterException {
        SerializedName serializedName = RecordTypeAdapterFactory.getComponentField(component).getAnnotation(SerializedName.class);
        SerializedName accessorSerializedName = component.getAccessor().getAnnotation(SerializedName.class);
        if (serializedName == null) {
            if (accessorSerializedName != null) {
                throw new RecordTypeAdapterException("@SerializedName on accessor method is not supported; place it on the corresponding record component instead");
            }
            String name = Objects.requireNonNull(this.namingStrategy.translateName(component));
            return new ComponentNames(name, Set.of(name));
        }
        if (accessorSerializedName != null && !serializedName.equals(accessorSerializedName)) {
            throw new RecordTypeAdapterException("Using different @SerializedName on accessor than on corresponding record component is not supported");
        }
        String name = serializedName.value();
        String[] alternates = serializedName.alternate();
        if (alternates.length == 0) {
            return new ComponentNames(name, Set.of(name));
        }
        LinkedHashSet<String> deserializationNames = new LinkedHashSet<String>();
        deserializationNames.add(name);
        for (String alternate : alternates) {
            if (deserializationNames.add(alternate)) continue;
            throw new RecordTypeAdapterException("Duplicate property name '" + alternate + "' for " + RecordTypeAdapterFactory.getComponentDisplayString(component));
        }
        return new ComponentNames(name, deserializationNames);
    }

    private static boolean needsRuntimeTypeTypeAdapter(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return !c.isPrimitive() && !Modifier.isFinal(c.getModifiers());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return RecordTypeAdapterFactory.needsRuntimeTypeTypeAdapter(parameterizedType.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return RecordTypeAdapterFactory.needsRuntimeTypeTypeAdapter(arrayType.getGenericComponentType());
        }
        return true;
    }

    private TypeAdapter<?> getAdapter(RecordComponent component, Type componentType, Gson gson) throws RecordTypeAdapterException {
        TypeAdapter typeAdapter;
        TypeToken componentTypeToken = TypeToken.get((Type)componentType);
        JsonAdapter jsonAdapterAnnotation = RecordTypeAdapterFactory.getComponentField(component).getAnnotation(JsonAdapter.class);
        if (jsonAdapterAnnotation == null) {
            TypeAdapter adapter = gson.getAdapter(componentTypeToken);
            if (this.serializeRuntimeComponentTypes && RecordTypeAdapterFactory.needsRuntimeTypeTypeAdapter(componentType)) {
                return new RuntimeTypeTypeAdapter(gson, adapter);
            }
            return adapter;
        }
        Class adapterType = jsonAdapterAnnotation.value();
        JsonAdapterCreator usedAdapterCreator = null;
        Object adapter = null;
        for (JsonAdapterCreator adapterCreator : this.jsonAdapterCreators) {
            Optional<Object> optAdapter;
            try {
                optAdapter = adapterCreator.create(adapterType);
            }
            catch (JsonAdapterCreator.AdapterCreationException e) {
                throw new RecordTypeAdapterException("Creator " + adapterCreator + " failed creating instance of adapter " + adapterType + " for " + RecordTypeAdapterFactory.getComponentDisplayString(component), e);
            }
            if (!optAdapter.isPresent()) continue;
            adapter = optAdapter.get();
            usedAdapterCreator = adapterCreator;
            break;
        }
        if (usedAdapterCreator == null) {
            String creatorsString = this.jsonAdapterCreators.stream().map(Object::toString).collect(Collectors.joining(", "));
            throw new RecordTypeAdapterException("None of the creators can create an instance of adapter " + adapterType + " for " + RecordTypeAdapterFactory.getComponentDisplayString(component) + "; registered creators: " + creatorsString);
        }
        if (adapter instanceof TypeAdapter) {
            typeAdapter = (TypeAdapter)adapter;
        } else if (adapter instanceof TypeAdapterFactory) {
            TypeAdapterFactory factory = (TypeAdapterFactory)adapter;
            typeAdapter = factory.create(gson, componentTypeToken);
            if (typeAdapter == null) {
                throw new RecordTypeAdapterException("Factory " + factory + " of type " + factory.getClass().getName() + " does not support type " + componentTypeToken + " of component " + RecordTypeAdapterFactory.getComponentDisplayString(component));
            }
        } else if (adapter instanceof JsonSerializer || adapter instanceof JsonDeserializer) {
            TypeAdapter r;
            JsonSerializer serializer = adapter instanceof JsonSerializer ? (JsonSerializer)adapter : null;
            JsonDeserializer deserializer = adapter instanceof JsonDeserializer ? (JsonDeserializer)adapter : null;
            typeAdapter = r = new TypeAdapter(serializer, deserializer, gson, componentTypeToken);
        } else {
            throw new RecordTypeAdapterException("Adapter " + adapter + " of type " + adapter.getClass().getName() + " created by " + usedAdapterCreator + " for " + RecordTypeAdapterFactory.getComponentDisplayString(component) + " is not supported");
        }
        return jsonAdapterAnnotation.nullSafe() ? typeAdapter.nullSafe() : typeAdapter;
    }

    private static String getComponentDisplayString(RecordComponent component) {
        return component.getDeclaringRecord().getName() + "." + component.getName();
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) throws RecordTypeAdapterException {
        int i;
        final Class rawType = type.getRawType();
        if (!rawType.isRecord()) {
            return null;
        }
        final RecordComponent[] components = rawType.getRecordComponents();
        final Constructor<?> constructor = RecordTypeAdapterFactory.getCanonicalConstructor(rawType, components);
        Type[] componentTypes = new Type[components.length];
        final Method[] accessors = new Method[components.length];
        final String[] componentSerializationNames = new String[components.length];
        final HashMap<String, Integer> componentDeserializationNames = new HashMap<String, Integer>();
        final TypeAdapter[] componentAdapters = new TypeAdapter[components.length];
        for (i = 0; i < components.length; ++i) {
            RecordComponent component = components[i];
            componentTypes[i] = component.getGenericType();
            Method accessor = component.getAccessor();
            try {
                accessor.setAccessible(true);
            }
            catch (InaccessibleObjectException e) {
                throw new RecordTypeAdapterException("Cannot access accessor method for " + RecordTypeAdapterFactory.getComponentDisplayString(component) + "; either change the visibility of the record class to `public` or open it to this library", e);
            }
            accessors[i] = accessor;
            ComponentNames componentNames = this.getComponentNames(component);
            String serializationName = componentNames.serializationName;
            for (int j = 0; j < i; ++j) {
                if (!componentSerializationNames[j].equals(serializationName)) continue;
                throw new RecordTypeAdapterException("Property name '" + serializationName + "' for " + RecordTypeAdapterFactory.getComponentDisplayString(component) + " clashes with name of other component");
            }
            componentSerializationNames[i] = serializationName;
            for (String deserializeName : componentNames.deserializationNames) {
                if (componentDeserializationNames.put(deserializeName, i) == null) continue;
                throw new RecordTypeAdapterException("Property name '" + deserializeName + "' for " + RecordTypeAdapterFactory.getComponentDisplayString(component) + " clashes with name of other component");
            }
        }
        componentTypes = ComponentTypeHelper.resolveComponentTypes(type, componentTypes);
        for (i = 0; i < components.length; ++i) {
            componentAdapters[i] = this.getAdapter(components[i], componentTypes[i], gson);
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                    return;
                }
                out.beginObject();
                for (int i = 0; i < accessors.length; ++i) {
                    Object componentValue;
                    try {
                        componentValue = accessors[i].invoke(value, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                        throw new JsonParseException("Failed getting component value", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new JsonParseException("Failed getting component value", e.getCause());
                    }
                    out.name(componentSerializationNames[i]);
                    TypeAdapter adapter = componentAdapters[i];
                    adapter.write(out, componentValue);
                }
                out.endObject();
            }

            public T read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.skipValue();
                    return null;
                }
                Object[] values = new Object[components.length];
                boolean[] hasValue = new boolean[values.length];
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    Integer i = (Integer)componentDeserializationNames.get(name);
                    if (i == null) {
                        if (RecordTypeAdapterFactory.this.allowUnknownProperties) {
                            in.skipValue();
                            continue;
                        }
                        throw new JsonParseException("Unknown property '" + name + "' for " + rawType + " at JSON path " + in.getPath());
                    }
                    RecordComponent component = components[i];
                    if (!RecordTypeAdapterFactory.this.allowDuplicateComponentValues && hasValue[i]) {
                        throw new JsonParseException("Duplicate value for " + RecordTypeAdapterFactory.getComponentDisplayString(component) + " provided by property '" + name + "' at JSON path " + in.getPath());
                    }
                    Class<?> componentType = component.getType();
                    boolean isPrimitive = componentType.isPrimitive();
                    if (!RecordTypeAdapterFactory.this.allowJsonNullForPrimitives && isPrimitive && in.peek() == JsonToken.NULL) {
                        throw new JsonParseException("JSON null is not allowed for primitive " + RecordTypeAdapterFactory.getComponentDisplayString(component) + " provided by property '" + name + "' at JSON path " + in.getPath());
                    }
                    Object value = componentAdapters[i].read(in);
                    if (isPrimitive && value == null) {
                        value = RecordTypeAdapterFactory.getPrimitiveDefaultValue(componentType);
                    }
                    values[i.intValue()] = value;
                    hasValue[i.intValue()] = true;
                }
                for (int i = 0; i < components.length; ++i) {
                    if (hasValue[i]) continue;
                    if (!RecordTypeAdapterFactory.this.allowMissingComponentValues) {
                        throw new JsonParseException("Missing value for " + RecordTypeAdapterFactory.getComponentDisplayString(components[i]) + "; last property is at JSON path " + in.getPath());
                    }
                    Class<?> componentType = components[i].getType();
                    if (!componentType.isPrimitive()) continue;
                    values[i] = RecordTypeAdapterFactory.getPrimitiveDefaultValue(componentType);
                }
                in.endObject();
                try {
                    Object result = constructor.newInstance(values);
                    return result;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                    throw new JsonParseException("Failed creating record instance for " + rawType, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new JsonParseException("Failed creating record instance for " + rawType, e.getCause());
                }
            }
        };
    }

    private static Constructor<?> getCanonicalConstructor(Class<?> recordType, RecordComponent[] components) throws RecordTypeAdapterException {
        Constructor<?> constructor;
        Class[] types = new Class[components.length];
        for (int i = 0; i < components.length; ++i) {
            types[i] = components[i].getType();
        }
        try {
            constructor = recordType.getDeclaredConstructor(types);
        }
        catch (NoSuchMethodException e) {
            throw new RecordTypeAdapterException("Unexpected: Failed finding canonical constructor for " + recordType, e);
        }
        try {
            constructor.setAccessible(true);
        }
        catch (InaccessibleObjectException e) {
            throw new RecordTypeAdapterException("Cannot access canonical constructor of " + recordType + "; either change the visibility of the record class to `public` or open it to this library", e);
        }
        return constructor;
    }

    private static Object getPrimitiveDefaultValue(Class<?> c) {
        if (c == Byte.TYPE) {
            return DEFAULT_BYTE;
        }
        if (c == Short.TYPE) {
            return DEFAULT_SHORT;
        }
        if (c == Integer.TYPE) {
            return DEFAULT_INT;
        }
        if (c == Long.TYPE) {
            return DEFAULT_LONG;
        }
        if (c == Float.TYPE) {
            return DEFAULT_FLOAT;
        }
        if (c == Double.TYPE) {
            return DEFAULT_DOUBLE;
        }
        if (c == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (c == Character.TYPE) {
            return DEFAULT_CHAR;
        }
        throw new AssertionError((Object)("Not primitive: " + c));
    }

    public static class Builder {
        private boolean serializeRuntimeComponentTypes = false;
        private boolean allowMissingComponentValues = false;
        private boolean allowUnknownProperties = true;
        private boolean allowDuplicateComponentValues = false;
        private boolean allowJsonNullForPrimitives = false;
        private RecordComponentNamingStrategy namingStrategy = DEFAULT_NAMING_STRATEGY;
        private final List<JsonAdapterCreator> jsonAdapterCreators = new ArrayList<JsonAdapterCreator>();

        private Builder() {
            this.jsonAdapterCreators.add(DEFAULT_JSON_ADAPTER_CREATOR);
        }

        public Builder serializeRuntimeComponentTypes() {
            this.serializeRuntimeComponentTypes = true;
            return this;
        }

        public Builder allowMissingComponentValues() {
            this.allowMissingComponentValues = true;
            return this;
        }

        public Builder disallowUnknownProperties() {
            this.allowUnknownProperties = false;
            return this;
        }

        public Builder allowDuplicateComponentValues() {
            this.allowDuplicateComponentValues = true;
            return this;
        }

        public Builder allowJsonNullForPrimitiveComponents() {
            this.allowJsonNullForPrimitives = true;
            return this;
        }

        public Builder withComponentNamingStrategy(RecordComponentNamingStrategy namingStrategy) {
            this.namingStrategy = Objects.requireNonNull(namingStrategy);
            return this;
        }

        public Builder registerJsonAdapterCreator(JsonAdapterCreator jsonAdapterCreator) {
            this.jsonAdapterCreators.add(Objects.requireNonNull(jsonAdapterCreator));
            return this;
        }

        public RecordTypeAdapterFactory create() {
            ArrayList<JsonAdapterCreator> jsonAdapterCreators = new ArrayList<JsonAdapterCreator>(this.jsonAdapterCreators);
            Collections.reverse(jsonAdapterCreators);
            return new RecordTypeAdapterFactory(this.serializeRuntimeComponentTypes, this.allowMissingComponentValues, this.allowUnknownProperties, this.allowDuplicateComponentValues, this.allowJsonNullForPrimitives, this.namingStrategy, jsonAdapterCreators);
        }
    }

    private record ComponentNames(String serializationName, Set<String> deserializationNames) {
    }
}

