/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.QueuedTooltip;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractTabbedConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class ClothConfigScreen
extends AbstractTabbedConfigScreen {
    private ScrollingContainer tabsScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, 1, ClothConfigScreen.this.field_22789 - 40);
        }

        @Override
        public int getMaxScrollHeight() {
            return (int)ClothConfigScreen.this.getTabsMaximumScrolled();
        }

        @Override
        public void updatePosition(float delta) {
            super.updatePosition(delta);
            this.scrollAmount = this.clamp(this.scrollAmount, 0.0);
        }
    };
    public ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private final LinkedHashMap<class_2561, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final List<class_3545<class_2561, Integer>> tabs;
    private class_339 quitButton;
    private class_339 saveButton;
    private class_339 buttonLeftTab;
    private class_339 buttonRightTab;
    private Rectangle tabsBounds;
    private Rectangle tabsLeftBounds;
    private Rectangle tabsRightBounds;
    private double tabsMaximumScrolled = -1.0;
    private final List<ClothConfigTabButton> tabButtons = Lists.newArrayList();
    private final Map<class_2561, ConfigCategory> categoryMap;

    @ApiStatus.Internal
    public ClothConfigScreen(class_437 parent, class_2561 title, Map<class_2561, ConfigCategory> categoryMap, class_2960 backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof class_3545 ? (AbstractConfigListEntry)((class_3545)object).method_15441() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put((class_2561)categoryName, entries);
            if (category.getBackground() != null) {
                this.registerCategoryBackground((class_2561)categoryName, category.getBackground());
            }
        });
        this.tabs = this.categorizedEntries.keySet().stream().map(s -> new class_3545(s, (Object)(class_310.method_1551().field_1772.method_27525((class_5348)s) + 8))).collect(Collectors.toList());
        this.categoryMap = categoryMap;
    }

    @Override
    public class_2561 getSelectedCategory() {
        return (class_2561)this.tabs.get(this.selectedCategoryIndex).method_15442();
    }

    @Override
    public Map<class_2561, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    @Override
    public boolean isEdited() {
        return super.isEdited();
    }

    @Override
    @Deprecated
    public void setEdited(boolean edited) {
        super.setEdited(edited);
    }

    @Override
    @Deprecated
    public void setEdited(boolean edited, boolean requiresRestart) {
        super.setEdited(edited, requiresRestart);
    }

    @Override
    public void saveAll(boolean openOtherScreens) {
        super.saveAll(openOtherScreens);
    }

    protected void method_25426() {
        super.method_25426();
        this.tabButtons.clear();
        this.listWidget = new ListWidget(this, this.field_22787, this.field_22789, this.field_22790, this.isShowingTabs() ? 70 : 30, this.field_22790 - 32, this.getBackgroundLocation());
        this.field_22786.add(this.listWidget);
        if (this.categorizedEntries.size() > this.selectedCategoryIndex) {
            this.listWidget.method_25396().addAll((List)Lists.newArrayList(this.categorizedEntries.values()).get(this.selectedCategoryIndex));
        }
        int buttonWidths = Math.min(200, (this.field_22789 - 50 - 12) / 3);
        this.quitButton = new class_4185(this.field_22789 / 2 - buttonWidths - 3, this.field_22790 - 26, buttonWidths, 20, (class_2561)(this.isEdited() ? new class_2588("text.cloth-config.cancel_discard") : new class_2588("gui.cancel")), widget -> this.quit());
        this.method_25411(this.quitButton);
        this.saveButton = new class_4185(this.field_22789 / 2 + 3, this.field_22790 - 26, buttonWidths, 20, class_333.field_18967, button -> this.saveAll(true)){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                for (List entries : Lists.newArrayList(ClothConfigScreen.this.categorizedEntries.values())) {
                    for (AbstractConfigEntry entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) continue;
                    break;
                }
                this.field_22763 = ClothConfigScreen.this.isEdited() && !hasErrors;
                this.method_25355((class_2561)(hasErrors ? new class_2588("text.cloth-config.error_cannot_save") : new class_2588("text.cloth-config.save_and_done")));
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        };
        this.method_25411(this.saveButton);
        this.saveButton.field_22763 = this.isEdited();
        if (this.isShowingTabs()) {
            this.tabsBounds = new Rectangle(0, 41, this.field_22789, 24);
            this.tabsLeftBounds = new Rectangle(0, 41, 18, 24);
            this.tabsRightBounds = new Rectangle(this.field_22789 - 18, 41, 18, 24);
            this.buttonLeftTab = new class_4185(4, 44, 12, 18, class_333.field_18967, button -> this.tabsScroller.scrollTo(0.0, true)){

                public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
                    ClothConfigScreen.this.field_22787.method_1531().method_22813(AbstractConfigScreen.CONFIG_TEX);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                    int int_3 = this.method_25356(this.method_25367());
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                    RenderSystem.blendFunc((int)770, (int)771);
                    this.method_25302(matrices, this.field_22760, this.field_22761, 12, 18 * int_3, this.field_22758, this.field_22759);
                }
            };
            this.field_22786.add(this.buttonLeftTab);
            int j = 0;
            for (class_3545<class_2561, Integer> tab : this.tabs) {
                this.tabButtons.add(new ClothConfigTabButton(this, j, -100, 43, (Integer)tab.method_15441(), 20, (class_2561)tab.method_15442(), this.categoryMap.get(tab.method_15442()).getDescription()));
                ++j;
            }
            this.field_22786.addAll(this.tabButtons);
            this.buttonRightTab = new class_4185(this.field_22789 - 16, 44, 12, 18, class_333.field_18967, button -> this.tabsScroller.scrollTo(this.tabsScroller.getMaxScroll(), true)){

                public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
                    ClothConfigScreen.this.field_22787.method_1531().method_22813(AbstractConfigScreen.CONFIG_TEX);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                    int int_3 = this.method_25356(this.method_25367());
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                    RenderSystem.blendFunc((int)770, (int)771);
                    this.method_25302(matrices, this.field_22760, this.field_22761, 0, 18 * int_3, this.field_22758, this.field_22759);
                }
            };
            this.field_22786.add(this.buttonRightTab);
        } else {
            this.tabsLeftBounds = this.tabsRightBounds = new Rectangle();
            this.tabsBounds = this.tabsRightBounds;
        }
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.tabsBounds.contains(mouseX, mouseY) && !this.tabsLeftBounds.contains(mouseX, mouseY) && !this.tabsRightBounds.contains(mouseX, mouseY) && amount != 0.0) {
            this.tabsScroller.offset(-amount * 16.0, true);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public double getTabsMaximumScrolled() {
        if (this.tabsMaximumScrolled == -1.0) {
            int[] i = new int[]{0};
            for (class_3545<class_2561, Integer> pair : this.tabs) {
                i[0] = i[0] + ((Integer)pair.method_15441() + 2);
            }
            this.tabsMaximumScrolled = i[0];
        }
        return this.tabsMaximumScrolled + 6.0;
    }

    public void resetTabsMaximumScrolled() {
        this.tabsMaximumScrolled = -1.0;
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.isShowingTabs()) {
            this.tabsScroller.updatePosition(delta * 3.0f);
            int xx = 24 - (int)this.tabsScroller.scrollAmount;
            for (ClothConfigTabButton tabButton : this.tabButtons) {
                tabButton.field_22760 = xx;
                xx += tabButton.method_25368() + 2;
            }
            this.buttonLeftTab.field_22763 = this.tabsScroller.scrollAmount > 0.0;
            boolean bl = this.buttonRightTab.field_22763 = this.tabsScroller.scrollAmount < this.getTabsMaximumScrolled() - (double)this.field_22789 + 40.0;
        }
        if (this.isTransparentBackground()) {
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        } else {
            this.method_25434(0);
        }
        this.listWidget.method_25394(matrices, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (Object child : this.listWidget.method_25396()) {
            ((AbstractConfigEntry)child).lateRender(matrices, mouseX, mouseY, delta);
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        if (this.isShowingTabs()) {
            ClothConfigScreen.method_27534((class_4587)matrices, (class_327)this.field_22787.field_1772, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)18, (int)-1);
            Rectangle onlyInnerTabBounds = new Rectangle(this.tabsBounds.x + 20, this.tabsBounds.y, this.tabsBounds.width - 40, this.tabsBounds.height);
            ScissorsHandler.INSTANCE.scissor(onlyInnerTabBounds);
            if (this.isTransparentBackground()) {
                this.method_25296(matrices, onlyInnerTabBounds.x, onlyInnerTabBounds.y, onlyInnerTabBounds.getMaxX(), onlyInnerTabBounds.getMaxY(), 0x68000000, 0x68000000);
            } else {
                this.overlayBackground(matrices, onlyInnerTabBounds, 32, 32, 32, 255, 255);
            }
            this.tabButtons.forEach(widget -> widget.method_25394(matrices, mouseX, mouseY, delta));
            this.drawTabsShades(matrices, 0, this.isTransparentBackground() ? 120 : 255);
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.buttonLeftTab.method_25394(matrices, mouseX, mouseY, delta);
            this.buttonRightTab.method_25394(matrices, mouseX, mouseY, delta);
        } else {
            ClothConfigScreen.method_27534((class_4587)matrices, (class_327)this.field_22787.field_1772, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)12, (int)-1);
        }
        if (this.isEditable()) {
            ArrayList errors = Lists.newArrayList();
            for (List entries : Lists.newArrayList(this.categorizedEntries.values())) {
                for (AbstractConfigEntry entry : entries) {
                    if (!entry.getConfigError().isPresent()) continue;
                    errors.add(entry.getConfigError().get());
                }
            }
            if (errors.size() > 0) {
                this.field_22787.method_1531().method_22813(CONFIG_TEX);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String text = "\u00a7c" + (errors.size() == 1 ? ((class_2561)errors.get(0)).method_27662().getString() : class_1074.method_4662((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
                if (this.isTransparentBackground()) {
                    int stringWidth = this.field_22787.field_1772.method_1727(text);
                    this.field_22787.field_1772.getClass();
                    this.method_25296(matrices, 8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
                }
                this.method_25302(matrices, 10, 10, 0, 54, 3, 11);
                ClothConfigScreen.method_25303((class_4587)matrices, (class_327)this.field_22787.field_1772, (String)text, (int)18, (int)12, (int)-1);
                if (errors.size() > 1) {
                    int stringWidth = this.field_22787.field_1772.method_1727(text);
                    if (mouseX >= 10 && mouseY >= 10 && mouseX <= 18 + stringWidth) {
                        this.field_22787.field_1772.getClass();
                        if (mouseY <= 14 + 9) {
                            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), errors.toArray(new class_2561[0])));
                        }
                    }
                }
            }
        } else if (!this.isEditable()) {
            this.field_22787.method_1531().method_22813(CONFIG_TEX);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String text = "\u00a7c" + class_1074.method_4662((String)"text.cloth-config.not_editable", (Object[])new Object[0]);
            if (this.isTransparentBackground()) {
                int stringWidth = this.field_22787.field_1772.method_1727(text);
                this.field_22787.field_1772.getClass();
                this.method_25296(matrices, 8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
            }
            this.method_25302(matrices, 10, 10, 0, 54, 3, 11);
            ClothConfigScreen.method_25303((class_4587)matrices, (class_327)this.field_22787.field_1772, (String)text, (int)18, (int)12, (int)-1);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void queueTooltip(QueuedTooltip queuedTooltip) {
        super.addTooltip(queuedTooltip);
    }

    private void drawTabsShades(class_4587 matrices, int lightColor, int darkColor) {
        this.drawTabsShades(matrices.method_23760().method_23761(), lightColor, darkColor);
    }

    private void drawTabsShades(class_1159 matrix, int lightColor, int darkColor) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22918(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)(this.tabsBounds.getMinY() + 4), 0.0f).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, lightColor).method_1344();
        buffer.method_22918(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)(this.tabsBounds.getMinY() + 4), 0.0f).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, lightColor).method_1344();
        buffer.method_22918(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)this.tabsBounds.getMinY(), 0.0f).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, darkColor).method_1344();
        buffer.method_22918(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)this.tabsBounds.getMinY(), 0.0f).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, darkColor).method_1344();
        tessellator.method_1350();
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22918(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)this.tabsBounds.getMaxY(), 0.0f).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, darkColor).method_1344();
        buffer.method_22918(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)this.tabsBounds.getMaxY(), 0.0f).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, darkColor).method_1344();
        buffer.method_22918(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)(this.tabsBounds.getMaxY() - 4), 0.0f).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, lightColor).method_1344();
        buffer.method_22918(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)(this.tabsBounds.getMaxY() - 4), 0.0f).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, lightColor).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    @Override
    public void save() {
        super.save();
    }

    @Override
    public boolean isEditable() {
        return super.isEditable();
    }

    public static class ListWidget<R extends DynamicElementListWidget.ElementEntry<R>>
    extends DynamicElementListWidget<R> {
        private AbstractConfigScreen screen;
        private boolean hasCurrent;
        private double currentX;
        private double currentY;
        private double currentWidth;
        private double currentHeight;
        public Rectangle target;
        public Rectangle thisTimeTarget;
        public long lastTouch;
        public long start;
        public long duration;

        public ListWidget(AbstractConfigScreen screen, class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
            this.setRenderSelection(false);
            this.screen = screen;
        }

        @Override
        public int getItemWidth() {
            return this.width - 80;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.left + this.width - 36;
        }

        @Override
        protected void renderItem(class_4587 matrices, R item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (item instanceof AbstractConfigEntry) {
                ((AbstractConfigEntry)item).updateSelected(this.getFocused() == item);
            }
            super.renderItem(matrices, item, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        @Override
        protected void renderList(class_4587 matrices, int startX, int startY, int int_3, int int_4, float delta) {
            long timePast;
            this.thisTimeTarget = null;
            if (this.hasCurrent) {
                timePast = System.currentTimeMillis() - this.lastTouch;
                int alpha = timePast <= 200L ? 255 : class_3532.method_15384((double)(255.0 - (double)(Math.min((float)(timePast - 200L), 500.0f) / 500.0f) * 255.0));
                alpha = alpha * 36 / 255 << 24;
                this.fillGradient(matrices, this.currentX, this.currentY, this.currentX + this.currentWidth, this.currentY + this.currentHeight, 0xFFFFFF | alpha, 0xFFFFFF | alpha);
            }
            super.renderList(matrices, startX, startY, int_3, int_4, delta);
            if (this.thisTimeTarget != null && this.method_25405(int_3, int_4)) {
                this.lastTouch = System.currentTimeMillis();
            }
            if (this.thisTimeTarget != null && !this.thisTimeTarget.equals((Object)this.target)) {
                if (!this.hasCurrent) {
                    this.currentX = this.thisTimeTarget.x;
                    this.currentY = this.thisTimeTarget.y;
                    this.currentWidth = this.thisTimeTarget.width;
                    this.currentHeight = this.thisTimeTarget.height;
                    this.hasCurrent = true;
                }
                this.target = this.thisTimeTarget.clone();
                this.start = this.lastTouch;
                this.duration = 40L;
            } else if (this.hasCurrent && this.target != null) {
                timePast = System.currentTimeMillis() - this.start;
                this.currentX = (int)ScrollingContainer.ease(this.currentX, this.target.x, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentY = (int)ScrollingContainer.ease(this.currentY, this.target.y, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentWidth = (int)ScrollingContainer.ease(this.currentWidth, this.target.width, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentHeight = (int)ScrollingContainer.ease(this.currentHeight, this.target.height, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
            }
        }

        protected void fillGradient(class_4587 matrices, double xStart, double yStart, double xEnd, double yEnd, int colorStart, int colorEnd) {
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            bufferBuilder.method_1328(7, class_290.field_1576);
            ListWidget.fillGradient(matrices.method_23760().method_23761(), bufferBuilder, xStart, yStart, xEnd, yEnd, this.method_25305(), colorStart, colorEnd);
            tessellator.method_1350();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }

        protected static void fillGradient(class_1159 matrix4f, class_287 bufferBuilder, double xStart, double yStart, double xEnd, double yEnd, int i, int j, int k) {
            float f = (float)(j >> 24 & 0xFF) / 255.0f;
            float g = (float)(j >> 16 & 0xFF) / 255.0f;
            float h = (float)(j >> 8 & 0xFF) / 255.0f;
            float l = (float)(j & 0xFF) / 255.0f;
            float m = (float)(k >> 24 & 0xFF) / 255.0f;
            float n = (float)(k >> 16 & 0xFF) / 255.0f;
            float o = (float)(k >> 8 & 0xFF) / 255.0f;
            float p = (float)(k & 0xFF) / 255.0f;
            bufferBuilder.method_22918(matrix4f, (float)xEnd, (float)yStart, (float)i).method_22915(g, h, l, f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)xStart, (float)yStart, (float)i).method_22915(g, h, l, f).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)xStart, (float)yEnd, (float)i).method_22915(n, o, p, m).method_1344();
            bufferBuilder.method_22918(matrix4f, (float)xEnd, (float)yEnd, (float)i).method_22915(n, o, p, m).method_1344();
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.updateScrollingState(mouseX, mouseY, button);
            if (!this.method_25405(mouseX, mouseY)) {
                return false;
            }
            for (DynamicElementListWidget.ElementEntry entry : this.method_25396()) {
                if (!entry.method_25402(mouseX, mouseY, button)) continue;
                this.method_25395(entry);
                this.method_25398(true);
                return true;
            }
            if (button == 0) {
                this.clickedHeader((int)(mouseX - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(mouseY - (double)this.top) + (int)this.getScroll() - 4);
                return true;
            }
            return this.scrolling;
        }

        @Override
        protected void renderBackBackground(class_4587 matrices, class_287 buffer, class_289 tessellator) {
            if (!this.screen.isTransparentBackground()) {
                super.renderBackBackground(matrices, buffer, tessellator);
            } else {
                this.method_25296(matrices, this.left, this.top, this.right, this.bottom, 0x68000000, 0x68000000);
            }
        }

        @Override
        protected void renderHoleBackground(class_4587 matrices, int y1, int y2, int alpha1, int alpha2) {
            if (!this.screen.isTransparentBackground()) {
                super.renderHoleBackground(matrices, y1, y2, alpha1, alpha2);
            }
        }
    }
}

