/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class IntSliderBuilder
extends FieldBuilder<Integer, IntegerSliderEntry> {
    private Consumer<Integer> saveConsumer = null;
    private Function<Integer, Optional<class_2561[]>> tooltipSupplier = i -> Optional.empty();
    private final int value;
    private int max;
    private int min;
    private Function<Integer, class_2561> textGetter = null;

    public IntSliderBuilder(class_2561 resetButtonKey, class_2561 fieldNameKey, int value, int min, int max) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
        this.max = max;
        this.min = min;
    }

    public IntSliderBuilder setErrorSupplier(Function<Integer, Optional<class_2561>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public IntSliderBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public IntSliderBuilder setTextGetter(Function<Integer, class_2561> textGetter) {
        this.textGetter = textGetter;
        return this;
    }

    public IntSliderBuilder setSaveConsumer(Consumer<Integer> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public IntSliderBuilder setDefaultValue(Supplier<Integer> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public IntSliderBuilder setDefaultValue(int defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public IntSliderBuilder setTooltipSupplier(Function<Integer, Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public IntSliderBuilder setTooltipSupplier(Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = i -> (Optional)tooltipSupplier.get();
        return this;
    }

    public IntSliderBuilder setTooltip(Optional<class_2561[]> tooltip) {
        this.tooltipSupplier = i -> tooltip;
        return this;
    }

    public IntSliderBuilder setTooltip(class_2561 ... tooltip) {
        this.tooltipSupplier = i -> Optional.ofNullable(tooltip);
        return this;
    }

    public IntSliderBuilder setMax(int max) {
        this.max = max;
        return this;
    }

    public IntSliderBuilder setMin(int min) {
        this.min = min;
        return this;
    }

    @Override
    @NotNull
    public IntegerSliderEntry build() {
        IntegerSliderEntry entry = new IntegerSliderEntry(this.getFieldNameKey(), this.min, this.max, this.value, this.getResetButtonKey(), this.defaultValue, this.saveConsumer, null, this.isRequireRestart());
        if (this.textGetter != null) {
            entry.setTextGetter(this.textGetter);
        }
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

