/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.tileentity;

import com.ayutaki.chinjufumod.blocks.furnace.CStove_top;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class CStove_TileEntity
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private String furnaceCustomName;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack countStack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(countStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)countStack);
        this.furnaceItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : "container.cstove";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.furnaceCustomName = p_145951_1_;
    }

    public static void registerFixesFurnace(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEntityFurnace.class, new String[]{"Items"}));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.furnaceItemStacks);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = CStove_TileEntity.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.furnaceItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack = (ItemStack)this.furnaceItemStacks.get(1);
            if (this.isBurning() || !stack.func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = CStove_TileEntity.getItemBurnTime(stack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!stack.func_190926_b()) {
                            Item item = stack.func_77973_b();
                            stack.func_190918_g(1);
                            if (stack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(stack);
                                this.furnaceItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime((ItemStack)this.furnaceItemStacks.get(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                CStove_top.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack stack1 = (ItemStack)this.furnaceItemStacks.get(2);
        if (stack1.func_190926_b()) {
            return true;
        }
        if (!stack1.func_77969_a(stack)) {
            return false;
        }
        if (stack1.func_190916_E() + stack.func_190916_E() <= this.func_70297_j_() && stack1.func_190916_E() + stack.func_190916_E() <= stack1.func_77976_d()) {
            return true;
        }
        return stack1.func_190916_E() + stack.func_190916_E() <= stack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack stack = (ItemStack)this.furnaceItemStacks.get(0);
            ItemStack stack1 = FurnaceRecipes.func_77602_a().func_151395_a(stack);
            ItemStack stack2 = (ItemStack)this.furnaceItemStacks.get(2);
            if (stack2.func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)stack1.func_77946_l());
            } else if (stack2.func_77973_b() == stack1.func_77973_b()) {
                stack2.func_190917_f(stack1.func_190916_E());
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && stack.func_77960_j() == 1 && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            stack.func_190918_g(1);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int burnTime = ForgeEventFactory.getItemBurnTime((ItemStack)stack);
        if (burnTime >= 0) {
            return burnTime;
        }
        Item item = stack.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150376_bx)) {
            return 225;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150325_L)) {
            return 150;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
            return 101;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150468_ap)) {
            return 450;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150471_bO)) {
            return 150;
        }
        if (Block.func_149634_a((Item)item).func_176223_P().func_185904_a() == Material.field_151575_d) {
            return 450;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
            return 24000;
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 300;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 300;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 300;
        }
        if (item == Items.field_151055_y) {
            return 150;
        }
        if (item != Items.field_151031_f && item != Items.field_151112_aM) {
            if (item == Items.field_151155_ap) {
                return 300;
            }
            if (item == Items.field_151044_h) {
                return 2400;
            }
            if (item == Items.field_151129_at) {
                return 30000;
            }
            if (item != Item.func_150898_a((Block)Blocks.field_150345_g) && item != Items.field_151054_z) {
                if (item == Items.field_151072_bj) {
                    return 3600;
                }
                if (item instanceof ItemDoor && item != Items.field_151139_aw) {
                    return 300;
                }
                return item instanceof ItemBoat ? 600 : 0;
            }
            return 150;
        }
        return 450;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return CStove_TileEntity.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer playerIn) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return playerIn.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer playerIn) {
    }

    public void func_174886_c(EntityPlayer playerIn) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack countStack = (ItemStack)this.furnaceItemStacks.get(1);
        return CStove_TileEntity.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && countStack.func_77973_b() != Items.field_151133_ar;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String func_174875_k() {
        return "minecraft:furnace";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFurnace(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.furnaceItemStacks.clear();
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

