/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.handler;

import com.ayutaki.chinjufumod.Config_CM;
import com.ayutaki.chinjufumod.world.biomegen.Biome_Ichoh;
import com.ayutaki.chinjufumod.world.biomegen.Biome_IchohHills;
import com.ayutaki.chinjufumod.world.biomegen.Biome_Kaede;
import com.ayutaki.chinjufumod.world.biomegen.Biome_KaedeHills;
import com.ayutaki.chinjufumod.world.biomegen.Biome_Sakura;
import com.ayutaki.chinjufumod.world.biomegen.Biome_SakuraHills;
import com.ayutaki.chinjufumod.world.biomegen.ModBiomeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Biomes_CM {
    public static final List<ModBiomeEntry> biomeEntryList = new ArrayList<ModBiomeEntry>();
    public static final Biome_Sakura BIOME_SAKURA = new Biome_Sakura();
    public static final Biome_SakuraHills BIOME_SAKURA_HILL = new Biome_SakuraHills();
    public static final Biome_Kaede BIOME_KAEDE = new Biome_Kaede();
    public static final Biome_KaedeHills BIOME_KAEDE_HILL = new Biome_KaedeHills();
    public static final Biome_Ichoh BIOME_ICHOH = new Biome_Ichoh();
    public static final Biome_IchohHills BIOME_ICHOH_HILL = new Biome_IchohHills();

    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        if (Config_CM.sakuraBiomeRegister) {
            event.getRegistry().register((IForgeRegistryEntry)BIOME_SAKURA);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_SAKURA, Config_CM.sakuraBiomeChance / 2));
            BiomeManager.addSpawnBiome((Biome)BIOME_SAKURA);
            event.getRegistry().register((IForgeRegistryEntry)BIOME_SAKURA_HILL);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_SAKURA_HILL, Config_CM.sakuraBiomeChance / 2));
            BiomeManager.addSpawnBiome((Biome)BIOME_SAKURA_HILL);
        }
        if (!Config_CM.sakuraBiomeRegister) {
            // empty if block
        }
        if (Config_CM.kaedeBiomeRegister) {
            event.getRegistry().register((IForgeRegistryEntry)BIOME_KAEDE);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_KAEDE, Config_CM.kaedeBiomeChance / 2));
            BiomeManager.addSpawnBiome((Biome)BIOME_KAEDE);
            event.getRegistry().register((IForgeRegistryEntry)BIOME_KAEDE_HILL);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_KAEDE_HILL, Config_CM.kaedeBiomeChance / 2));
            BiomeManager.addSpawnBiome((Biome)BIOME_KAEDE_HILL);
        }
        if (!Config_CM.kaedeBiomeRegister) {
            // empty if block
        }
        if (Config_CM.ichohBiomeRegister) {
            event.getRegistry().register((IForgeRegistryEntry)BIOME_ICHOH);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_ICHOH, Config_CM.ichohBiomeChance / 2));
            BiomeManager.addSpawnBiome((Biome)BIOME_ICHOH);
            event.getRegistry().register((IForgeRegistryEntry)BIOME_ICHOH_HILL);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_ICHOH_HILL, Config_CM.ichohBiomeChance / 2));
            BiomeManager.addSpawnBiome((Biome)BIOME_ICHOH_HILL);
        }
        if (!Config_CM.ichohBiomeRegister) {
            // empty if block
        }
    }

    private static void registerBiome(RegistryEvent.Register<Biome> event, ModBiomeBase biome, BiomeManager.BiomeType type, int weight, BiomeDictionary.Type ... biomeDictTypes) {
        event.getRegistry().register((IForgeRegistryEntry)biome);
        for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
        }
        biomeEntryList.add(new ModBiomeEntry(biome, type, weight));
    }

    public static class ModBiomeEntry {
        private final int weight;
        private final Biome biome;
        private final BiomeManager.BiomeType type;
        private final BiomeManager.BiomeEntry entry;

        private ModBiomeEntry(ModBiomeBase biome, BiomeManager.BiomeType type, int weight) {
            this.type = type;
            this.biome = biome;
            this.weight = weight;
            this.entry = new BiomeManager.BiomeEntry((Biome)biome, weight);
        }

        public ModBiomeBase getBiome() {
            return (ModBiomeBase)this.biome;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }

        public BiomeManager.BiomeType getType() {
            return this.type;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

