/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.wood.treegen;

import com.ayutaki.chinjufumod.registry.Seasonal_Blocks;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenTree_OakKare
extends WorldGenAbstractTree {
    private IBlockState blockStateWood = Seasonal_Blocks.OAKKARE_log.func_176223_P();
    private IBlockState blockStateLeaves = Seasonal_Blocks.OAKKARE_leaf.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final int minTreeHeight = 4;

    public WorldGenTree_OakKare(boolean parShouldNotify) {
        super(parShouldNotify);
    }

    public boolean func_180709_b(World parWorld, Random parRandom, BlockPos parBlockPos) {
        int minHeight = parRandom.nextInt(3) + 4;
        if (parBlockPos.func_177956_o() >= 1 && parBlockPos.func_177956_o() + minHeight + 1 <= parWorld.func_72800_K()) {
            if (!this.isSuitableLocation(parWorld, parBlockPos, minHeight)) {
                return false;
            }
            IBlockState state = parWorld.func_180495_p(parBlockPos.func_177977_b());
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)parWorld, parBlockPos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150345_g) && parBlockPos.func_177956_o() < parWorld.func_72800_K() - minHeight - 1) {
                state.func_177230_c().onPlantGrow(state, parWorld, parBlockPos.func_177977_b(), parBlockPos);
                this.generateLeaves(parWorld, parBlockPos, minHeight, parRandom);
                this.generateTrunk(parWorld, parBlockPos, minHeight);
                return true;
            }
            return false;
        }
        return false;
    }

    private void generateLeaves(World parWorld, BlockPos parBlockPos, int height, Random parRandom) {
        for (int foliageY = parBlockPos.func_177956_o() - 3 + height; foliageY <= parBlockPos.func_177956_o() + height; ++foliageY) {
            int foliageLayer = foliageY - (parBlockPos.func_177956_o() + height);
            int foliageLayerRadius = 1 - foliageLayer / 2;
            for (int foliageX = parBlockPos.func_177958_n() - foliageLayerRadius; foliageX <= parBlockPos.func_177958_n() + foliageLayerRadius; ++foliageX) {
                int foliageRelativeX = foliageX - parBlockPos.func_177958_n();
                for (int foliageZ = parBlockPos.func_177952_p() - foliageLayerRadius; foliageZ <= parBlockPos.func_177952_p() + foliageLayerRadius; ++foliageZ) {
                    BlockPos blockPos;
                    IBlockState state;
                    int foliageRelativeZ = foliageZ - parBlockPos.func_177952_p();
                    if (Math.abs(foliageRelativeX) == foliageLayerRadius && Math.abs(foliageRelativeZ) == foliageLayerRadius && (parRandom.nextInt(2) == 0 || foliageLayer == 0) || !(state = parWorld.func_180495_p(blockPos = new BlockPos(foliageX, foliageY, foliageZ))).func_177230_c().isAir(state, (IBlockAccess)parWorld, blockPos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)parWorld, blockPos)) continue;
                    this.func_175903_a(parWorld, blockPos, this.blockStateLeaves);
                }
            }
        }
    }

    private void generateTrunk(World parWorld, BlockPos parBlockPos, int minHeight) {
        for (int height = 0; height < minHeight; ++height) {
            BlockPos upN = parBlockPos.func_177981_b(height);
            IBlockState state = parWorld.func_180495_p(upN);
            if (!state.func_177230_c().isAir(state, (IBlockAccess)parWorld, upN) && !state.func_177230_c().isLeaves(state, (IBlockAccess)parWorld, upN)) continue;
            this.func_175903_a(parWorld, parBlockPos.func_177981_b(height), this.blockStateWood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
        }
    }

    private boolean isSuitableLocation(World parWorld, BlockPos parBlockPos, int minHeight) {
        boolean isSuitableLocation = true;
        for (int checkY = parBlockPos.func_177956_o(); checkY <= parBlockPos.func_177956_o() + 1 + minHeight; ++checkY) {
            int extraSpaceNeeded = 1;
            if (checkY == parBlockPos.func_177956_o()) {
                extraSpaceNeeded = 0;
            }
            if (checkY >= parBlockPos.func_177956_o() + 1 + minHeight - 2) {
                extraSpaceNeeded = 2;
            }
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int checkX = parBlockPos.func_177958_n() - extraSpaceNeeded; checkX <= parBlockPos.func_177958_n() + extraSpaceNeeded && isSuitableLocation; ++checkX) {
                for (int checkZ = parBlockPos.func_177952_p() - extraSpaceNeeded; checkZ <= parBlockPos.func_177952_p() + extraSpaceNeeded && isSuitableLocation; ++checkZ) {
                    isSuitableLocation = this.isReplaceable(parWorld, (BlockPos)blockPos.func_181079_c(checkX, checkY, checkZ));
                }
            }
        }
        return isSuitableLocation;
    }
}

