/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.wood.treegen;

import com.ayutaki.chinjufumod.registry.Seasonal_Blocks;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenTree_KaedeBig
extends WorldGenAbstractTree {
    private Random rand;
    private World world;
    private BlockPos basePos = BlockPos.field_177992_a;
    int heightLimit;
    int height;
    double heightAttenuation = 0.618;
    double branchSlope = 0.381;
    double scaleWidth = 1.0;
    double leafDensity = 1.0;
    int trunkSize = 1;
    int heightLimitLimit = 10;
    int leafDistanceLimit = 4;
    List<FoliageCoordinates> foliageCoords;
    private IBlockState leave;

    public WorldGenTree_KaedeBig(boolean notify) {
        super(notify);
        this.leave = Seasonal_Blocks.KAEDE_leaf.func_176223_P();
    }

    public WorldGenTree_KaedeBig(boolean notify, IBlockState state) {
        super(notify);
        this.leave = state;
    }

    public IBlockState getLeaveState() {
        return this.leave;
    }

    public Block getLog() {
        return Seasonal_Blocks.KAEDE_log;
    }

    public Block getSapling() {
        return Seasonal_Blocks.KAEDE_nae;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.world = worldIn;
        this.basePos = position;
        this.rand = new Random(rand.nextLong());
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            this.world = null;
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        this.world = null;
        return true;
    }

    void generateLeafNodeList() {
        int k;
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int j = this.basePos.func_177956_o() + this.height;
        this.foliageCoords = Lists.newArrayList();
        this.foliageCoords.add(new FoliageCoordinates(this.basePos.func_177981_b(k), j));
        for (k = this.heightLimit - this.leafDistanceLimit; k >= 0; --k) {
            float f = this.layerSize(k);
            if (!(f >= 0.0f)) continue;
            for (int l = 0; l < i; ++l) {
                BlockPos pos1;
                double d3;
                double d1;
                double d0 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                double d2 = d0 * Math.sin(d1 = (double)(this.rand.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos pos = this.basePos.func_177963_a(d2, (double)(k - 1), d3 = d0 * Math.cos(d1) + 0.5);
                if (this.checkBlockLine(pos, pos1 = pos.func_177981_b(this.leafDistanceLimit)) != -1) continue;
                int i1 = this.basePos.func_177958_n() - pos.func_177958_n();
                int j1 = this.basePos.func_177952_p() - pos.func_177952_p();
                double d4 = (double)pos.func_177956_o() - Math.sqrt(i1 * i1 + j1 * j1) * this.branchSlope;
                int k1 = d4 > (double)j ? j : (int)d4;
                BlockPos pos2 = new BlockPos(this.basePos.func_177958_n(), k1, this.basePos.func_177952_p());
                if (this.checkBlockLine(pos2, pos) != -1) continue;
                this.foliageCoords.add(new FoliageCoordinates(pos, pos2.func_177956_o()));
            }
        }
    }

    void crosSection(BlockPos pos, float p_181631_2_, IBlockState p_181631_3_) {
        int i = (int)((double)p_181631_2_ + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos pos1;
                IBlockState state;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(p_181631_2_ * p_181631_2_)) || !(state = this.world.func_180495_p(pos1 = pos.func_177982_a(j, 0, k))).func_177230_c().isAir(state, (IBlockAccess)this.world, pos1) && !state.func_177230_c().isLeaves(state, (IBlockAccess)this.world, pos1)) continue;
                this.func_175903_a(this.world, pos1, p_181631_3_);
            }
        }
    }

    float layerSize(int y) {
        if ((float)y < (float)this.heightLimit * 0.3f) {
            return -1.0f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = f - (float)y;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    float leafSize(int y) {
        if (y >= 0 && y < this.leafDistanceLimit) {
            return y != 0 && y != this.leafDistanceLimit - 1 ? 3.0f : 2.0f;
        }
        return -1.0f;
    }

    void generateLeafNode(BlockPos pos) {
        for (int i = 0; i < this.leafDistanceLimit; ++i) {
            this.crosSection(pos.func_177981_b(i), this.leafSize(i), this.getLeaveState());
        }
    }

    void limb(BlockPos p_175937_1_, BlockPos p_175937_2_, Block p_175937_3_) {
        BlockPos pos1 = p_175937_2_.func_177982_a(-p_175937_1_.func_177958_n(), -p_175937_1_.func_177956_o(), -p_175937_1_.func_177952_p());
        int i = this.getGreatestDistance(pos1);
        float f = (float)pos1.func_177958_n() / (float)i;
        float f1 = (float)pos1.func_177956_o() / (float)i;
        float f2 = (float)pos1.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos pos2 = p_175937_1_.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            BlockLog.EnumAxis blocklog$enumaxis = this.getLogAxis(p_175937_1_, pos2);
            this.func_175903_a(this.world, pos2, p_175937_3_.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)blocklog$enumaxis));
        }
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        if (k > i && k > j) {
            return k;
        }
        return j > i ? j : i;
    }

    private BlockLog.EnumAxis getLogAxis(BlockPos p_175938_1_, BlockPos p_175938_2_) {
        int j;
        BlockLog.EnumAxis blocklog$enumaxis = BlockLog.EnumAxis.Y;
        int i = Math.abs(p_175938_2_.func_177958_n() - p_175938_1_.func_177958_n());
        int k = Math.max(i, j = Math.abs(p_175938_2_.func_177952_p() - p_175938_1_.func_177952_p()));
        if (k > 0) {
            if (i == k) {
                blocklog$enumaxis = BlockLog.EnumAxis.X;
            } else if (j == k) {
                blocklog$enumaxis = BlockLog.EnumAxis.Z;
            }
        }
        return blocklog$enumaxis;
    }

    void generateLeaves() {
        for (FoliageCoordinates BlockBigTreeSakura$foliagecoordinates : this.foliageCoords) {
            this.generateLeafNode(BlockBigTreeSakura$foliagecoordinates);
        }
    }

    boolean leafNodeNeedsBase(int p_76493_1_) {
        return (double)p_76493_1_ >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        BlockPos pos = this.basePos;
        BlockPos pos1 = this.basePos.func_177981_b(this.height);
        Block block = this.getLog();
        this.limb(pos, pos1, block);
        if (this.trunkSize == 2) {
            this.limb(pos.func_177974_f(), pos1.func_177974_f(), block);
            this.limb(pos.func_177974_f().func_177968_d(), pos1.func_177974_f().func_177968_d(), block);
            this.limb(pos.func_177968_d(), pos1.func_177968_d(), block);
        }
    }

    void generateLeafNodeBases() {
        for (FoliageCoordinates BlockBigTreeSakura$foliagecoordinates : this.foliageCoords) {
            int i = BlockBigTreeSakura$foliagecoordinates.getBranchBase();
            BlockPos pos = new BlockPos(this.basePos.func_177958_n(), i, this.basePos.func_177952_p());
            if (pos.equals((Object)BlockBigTreeSakura$foliagecoordinates) || !this.leafNodeNeedsBase(i - this.basePos.func_177956_o())) continue;
            this.limb(pos, BlockBigTreeSakura$foliagecoordinates, this.getLog());
        }
    }

    int checkBlockLine(BlockPos posOne, BlockPos posTwo) {
        BlockPos pos = posTwo.func_177982_a(-posOne.func_177958_n(), -posOne.func_177956_o(), -posOne.func_177952_p());
        int i = this.getGreatestDistance(pos);
        float f = (float)pos.func_177958_n() / (float)i;
        float f1 = (float)pos.func_177956_o() / (float)i;
        float f2 = (float)pos.func_177952_p() / (float)i;
        if (i == 0) {
            return -1;
        }
        for (int j = 0; j <= i; ++j) {
            BlockPos pos1 = posOne.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (this.isReplaceable(this.world, pos1)) continue;
            return j;
        }
        return -1;
    }

    public void func_175904_e() {
        this.leafDistanceLimit = 5;
    }

    private boolean validTreeLocation() {
        BlockPos down = this.basePos.func_177977_b();
        IBlockState state = this.world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)this.world, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
        if (!isSoil) {
            return false;
        }
        int i = this.checkBlockLine(this.basePos, this.basePos.func_177981_b(this.heightLimit - 1));
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int p_i45635_2_) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = p_i45635_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

