/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.window;

import com.ayutaki.chinjufumod.blocks.base.CollisionHelper;
import com.ayutaki.chinjufumod.handler.CMEvents;
import com.ayutaki.chinjufumod.items.color.Base_ItemHake;
import com.ayutaki.chinjufumod.registry.Items_Chinjufu;
import com.ayutaki.chinjufumod.registry.Window_Blocks;
import com.ayutaki.chinjufumod.state.HalfState;
import com.ayutaki.chinjufumod.state.HingeState;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CurtainTall
extends Block {
    public static final PropertyDirection H_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<HingeState> HINGE = PropertyEnum.func_177709_a((String)"hinge", HingeState.class);
    public static final PropertyEnum<HalfState> HALF = PropertyEnum.func_177709_a((String)"half", HalfState.class);
    protected static final AxisAlignedBB AABB_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OR_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.86875, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OR_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.86875, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OR_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.86875, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OR_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.86875, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OL_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.86875, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_OL_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.86875, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_OL_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.86875, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_OL_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.86875, 0.0, 0.0, 1.0, 1.0, 0.125);

    public CurtainTall(String name) {
        super(Material.field_151575_d);
        this.setRegistryName(new ResourceLocation("chinjufumod", name));
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a(HINGE, (Comparable)((Object)HingeState.RIGHT)).func_177226_a(HALF, (Comparable)((Object)HalfState.UPPER)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
        boolean flag = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == HingeState.LEFT;
        switch (direction) {
            case SOUTH: {
                return flag ? AABB_SOUTH : (flag1 ? AABB_OL_SOUTH : AABB_OR_SOUTH);
            }
            case EAST: {
                return flag ? AABB_EAST : (flag1 ? AABB_OL_EAST : AABB_OR_EAST);
            }
            case WEST: {
                return flag ? AABB_WEST : (flag1 ? AABB_OL_WEST : AABB_OR_WEST);
            }
        }
        return flag ? AABB_NORTH : (flag1 ? AABB_OL_NORTH : AABB_OR_NORTH);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return CurtainTall.isOpen(CurtainTall.combineMetadata(worldIn, pos));
    }

    public static boolean isOpen(IBlockAccess worldIn, BlockPos pos) {
        return CurtainTall.isOpen(CurtainTall.combineMetadata(worldIn, pos));
    }

    public static EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
        return CurtainTall.getFacing(CurtainTall.combineMetadata(worldIn, pos));
    }

    public static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        int i = state.func_177230_c().func_176201_c(state);
        boolean flag = CurtainTall.isTop(i);
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        int j = downState.func_177230_c().func_176201_c(downState);
        int k = flag ? j : i;
        IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        int l = upState.func_177230_c().func_176201_c(upState);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return CurtainTall.removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    protected static boolean isOpen(int combinedMeta) {
        return (combinedMeta & 4) != 0;
    }

    public static EnumFacing getFacing(int combinedMeta) {
        return EnumFacing.func_176731_b((int)(combinedMeta & 3)).func_176735_f();
    }

    protected static boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    protected static int removeHalfBit(int meta) {
        return meta & 7;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos pos1 = state.func_177229_b(HALF) == HalfState.LOWER ? pos : pos.func_177977_b();
        IBlockState state1 = pos.equals((Object)pos1) ? state : worldIn.func_180495_p(pos1);
        ItemStack stack = playerIn.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item instanceof Base_ItemHake) {
            return false;
        }
        state = state1.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos1, state, 10);
        worldIn.func_175704_b(pos1, pos);
        CMEvents.soundCurtain(worldIn, pos, 0.8f, 0.85f);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == HalfState.UPPER) {
            BlockPos downPos = pos.func_177977_b();
            IBlockState downState = worldIn.func_180495_p(downPos);
            if (downState.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                downState.func_189546_a(worldIn, downPos, blockIn, fromPos);
            }
        } else {
            boolean flag1 = false;
            BlockPos upPos = pos.func_177984_a();
            IBlockState upState = worldIn.func_180495_p(upPos);
            if (upState.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (flag1 && !worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_185904_a().func_76222_j() && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        BlockPos downPos = pos.func_177977_b();
        BlockPos upPos = pos.func_177984_a();
        if (playerIn.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == HalfState.UPPER && worldIn.func_180495_p(downPos).func_177230_c() == this) {
            worldIn.func_175698_g(downPos);
        }
        if (state.func_177229_b(HALF) == HalfState.LOWER && worldIn.func_180495_p(upPos).func_177230_c() == this) {
            if (playerIn.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(upPos);
        }
    }

    public boolean canSilkHarvest(World worldIn, EntityPlayer playerIn, int x, int y, int z, int metadata) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        stack.add(this.takeStack(state));
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        return this.takeStack(state);
    }

    private ItemStack takeStack(IBlockState state) {
        if (state.func_177229_b(HALF) == HalfState.UPPER) {
            return new ItemStack(Items.field_190931_a);
        }
        if (state.func_177229_b(HALF) != HalfState.UPPER) {
            if (this == Window_Blocks.CURTAINTALL_white) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 0);
            }
            if (this == Window_Blocks.CURTAINTALL_orange) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 1);
            }
            if (this == Window_Blocks.CURTAINTALL_magenta) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 2);
            }
            if (this == Window_Blocks.CURTAINTALL_lightblue) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 3);
            }
            if (this == Window_Blocks.CURTAINTALL_yellow) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 4);
            }
            if (this == Window_Blocks.CURTAINTALL_lime) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 5);
            }
            if (this == Window_Blocks.CURTAINTALL_pink) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 6);
            }
            if (this == Window_Blocks.CURTAINTALL_gray) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 7);
            }
            if (this == Window_Blocks.CURTAINTALL_lightgray) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 8);
            }
            if (this == Window_Blocks.CURTAINTALL_cyan) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 9);
            }
            if (this == Window_Blocks.CURTAINTALL_purple) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 10);
            }
            if (this == Window_Blocks.CURTAINTALL_blue) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 11);
            }
            if (this == Window_Blocks.CURTAINTALL_brown) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 12);
            }
            if (this == Window_Blocks.CURTAINTALL_green) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 13);
            }
            if (this == Window_Blocks.CURTAINTALL_red) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 14);
            }
            if (this == Window_Blocks.CURTAINTALL_black) {
                return new ItemStack(Items_Chinjufu.CURTAINTALL_item, 1, 15);
            }
        }
        return null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == HalfState.LOWER) {
            IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
            if (upState.func_177230_c() == this) {
                state = state.func_177226_a(HINGE, upState.func_177229_b(HINGE));
            }
        } else {
            IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
            if (downState.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)H_FACING, downState.func_177229_b((IProperty)H_FACING)).func_177226_a((IProperty)OPEN, downState.func_177229_b((IProperty)OPEN));
            }
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177229_b(HALF) != HalfState.LOWER ? state : state.func_177226_a((IProperty)H_FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)H_FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)H_FACING))).func_177231_a(HINGE);
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)HalfState.UPPER)).func_177226_a(HINGE, (Comparable)((Object)((meta & 1) > 0 ? HingeState.LEFT : HingeState.RIGHT))) : this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)HalfState.LOWER)).func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == HalfState.UPPER) {
            i |= 8;
            if (state.func_177229_b(HINGE) == HingeState.LEFT) {
                i |= 1;
            }
        } else {
            i |= ((EnumFacing)state.func_177229_b((IProperty)H_FACING)).func_176746_e().func_176736_b();
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, H_FACING, OPEN, HINGE});
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

