/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.school;

import com.ayutaki.chinjufumod.blocks.base.CollisionHelper;
import com.ayutaki.chinjufumod.entity.SitableEntity;
import com.ayutaki.chinjufumod.entity.helper.SittableUtil;
import com.ayutaki.chinjufumod.handler.CMEvents;
import com.ayutaki.chinjufumod.registry.Furniture_Blocks;
import com.ayutaki.chinjufumod.registry.Items_Chinjufu;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SchoolChair
extends Block {
    public static final PropertyDirection H_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.4375, 0.875);
    private static final AxisAlignedBB CHAIR_BASE = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.4375, 0.875);
    private static final AxisAlignedBB CHAIR_BACKREST_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.125, 0.4375, 0.125, 0.1875, 1.0, 0.875);
    private static final AxisAlignedBB CHAIR_BACKREST_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.125, 0.4375, 0.125, 0.1875, 1.0, 0.875);
    private static final AxisAlignedBB CHAIR_BACKREST_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.125, 0.4375, 0.125, 0.1875, 1.0, 0.875);
    private static final AxisAlignedBB CHAIR_BACKREST_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.125, 0.4375, 0.125, 0.1875, 1.0, 0.875);

    public SchoolChair(String name) {
        super(Material.field_151575_d);
        this.setRegistryName(new ResourceLocation("chinjufumod", name));
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.21875)) {
            worldIn.func_175666_e(pos, (Block)this);
            CMEvents.soundSitChair(worldIn, pos);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean t_f) {
        if (!(entityIn instanceof SitableEntity)) {
            EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
            switch (direction) {
                case SOUTH: {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_SOUTH);
                    break;
                }
                case EAST: {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_EAST);
                    break;
                }
                case WEST: {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_WEST);
                    break;
                }
                default: {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_NORTH);
                }
            }
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BASE);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)H_FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)H_FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{H_FACING});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return SittableUtil.isSomeoneSitting(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) ? 1 : 0;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canSilkHarvest(World worldIn, EntityPlayer playerIn, int x, int y, int z, int metadata) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        stack.add(this.takeStack(state));
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        return this.takeStack(state);
    }

    private ItemStack takeStack(IBlockState state) {
        if (this == Furniture_Blocks.SCHOOLCHAIR) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 0);
        }
        if (this == Furniture_Blocks.SCHOOLCHAIR_s) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 1);
        }
        if (this == Furniture_Blocks.SCHOOLCHAIR_b) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 2);
        }
        if (this == Furniture_Blocks.SCHOOLCHAIR_j) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 3);
        }
        if (this == Furniture_Blocks.SCHOOLCHAIR_a) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 4);
        }
        if (this == Furniture_Blocks.SCHOOLCHAIR_d) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 5);
        }
        if (this == Furniture_Blocks.SCHOOLCHAIR_saku) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 6);
        }
        if (this == Furniture_Blocks.SCHOOLCHAIR_kae) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 7);
        }
        if (this == Furniture_Blocks.SCHOOLCHAIR_ich) {
            return new ItemStack(Items_Chinjufu.SCHOOLCHAIR_item, 1, 8);
        }
        return null;
    }
}

