/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.gate;

import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import com.ayutaki.chinjufumod.registry.Items_Wadeco;
import com.ayutaki.chinjufumod.registry.doors.Gate_Blocks;
import com.ayutaki.chinjufumod.state.HalfState;
import com.ayutaki.chinjufumod.state.HingeState;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseGate
extends Block {
    public static final PropertyDirection H_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<HingeState> HINGE = PropertyEnum.func_177709_a((String)"hinge", HingeState.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<HalfState> HALF = PropertyEnum.func_177709_a((String)"half", HalfState.class);

    public BaseGate(Material material, String name) {
        super(material);
        this.setRegistryName(new ResourceLocation("chinjufumod", name));
        this.func_149663_c(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a(HINGE, (Comparable)((Object)HingeState.RIGHT)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(HALF, (Comparable)((Object)HalfState.UPPER)));
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return BaseGate.isOpen(BaseGate.combineMetadata(worldIn, pos));
    }

    public static boolean isOpen(IBlockAccess worldIn, BlockPos pos) {
        return BaseGate.isOpen(BaseGate.combineMetadata(worldIn, pos));
    }

    public static EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
        return BaseGate.getFacing(BaseGate.combineMetadata(worldIn, pos));
    }

    public static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        int i = state.func_177230_c().func_176201_c(state);
        boolean flag = BaseGate.isTop(i);
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        int j = downState.func_177230_c().func_176201_c(downState);
        int k = flag ? j : i;
        IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        int l = upState.func_177230_c().func_176201_c(upState);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return BaseGate.removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    protected static boolean isOpen(int combinedMeta) {
        return (combinedMeta & 4) != 0;
    }

    public static EnumFacing getFacing(int combinedMeta) {
        return EnumFacing.func_176731_b((int)(combinedMeta & 3)).func_176735_f();
    }

    protected static boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    protected static int removeHalfBit(int meta) {
        return meta & 7;
    }

    protected void moveSound(World worldIn, BlockPos pos, boolean open) {
        boolean flag1;
        boolean flag = this == Gate_Blocks.GATE_SPRUCE || this == Gate_Blocks.GATE_SPRUCE2 || this == Gate_Blocks.GATE_SPRUCE_B || this == Gate_Blocks.GATE_SPRUCE_B2;
        boolean bl = flag1 = this == Gate_Blocks.GATE_IRON || this == Gate_Blocks.GATE_IRON2;
        if (open) {
            worldIn.func_184133_a(null, pos, flag ? SoundEvents_CM.GATE_WOOD : SoundEvents_CM.GATE_IRON_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (!open) {
            worldIn.func_184133_a(null, pos, flag ? SoundEvents_CM.GATE_WOOD : (flag1 ? SoundEvents_CM.GATE_IRON_CLOSE : SoundEvents_CM.GATE_IRON_OPEN), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_185904_a().func_76222_j() && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j();
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        if (state.func_177229_b(HALF) != HalfState.LOWER) {
            stack.add(new ItemStack(Items.field_190931_a, 1, 0));
        }
        if (state.func_177229_b(HALF) == HalfState.LOWER) {
            stack.add(this.takeStack());
        }
        return stack;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.takeStack();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        return this.takeStack();
    }

    private ItemStack takeStack() {
        if (this == Gate_Blocks.GATE_SPRUCE_B || this == Gate_Blocks.GATE_SPRUCE_B2) {
            return new ItemStack(Items_Wadeco.GATE, 1, 0);
        }
        if (this == Gate_Blocks.GATE_SPRUCE || this == Gate_Blocks.GATE_SPRUCE2) {
            return new ItemStack(Items_Wadeco.GATE, 1, 1);
        }
        if (this == Gate_Blocks.GATE_IRON || this == Gate_Blocks.GATE_IRON2) {
            return new ItemStack(Items_Wadeco.GATE, 1, 2);
        }
        if (this == Gate_Blocks.GATE_IRONGRILL || this == Gate_Blocks.GATE_IRONGRILL2) {
            return new ItemStack(Items_Wadeco.GATE, 1, 3);
        }
        return null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == HalfState.LOWER) {
            IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
            if (upState.func_177230_c() == this) {
                state = state.func_177226_a(HINGE, upState.func_177229_b(HINGE)).func_177226_a((IProperty)POWERED, upState.func_177229_b((IProperty)POWERED));
            }
        } else {
            IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
            if (downState.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)H_FACING, downState.func_177229_b((IProperty)H_FACING)).func_177226_a((IProperty)OPEN, downState.func_177229_b((IProperty)OPEN));
            }
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177229_b(HALF) != HalfState.LOWER ? state : state.func_177226_a((IProperty)H_FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)H_FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)H_FACING))).func_177231_a(HINGE);
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)HalfState.UPPER)).func_177226_a(HINGE, (Comparable)((Object)((meta & 1) > 0 ? HingeState.RIGHT : HingeState.LEFT))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 2) > 0)) : this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)HalfState.LOWER)).func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == HalfState.UPPER) {
            i |= 8;
            if (state.func_177229_b(HINGE) == HingeState.RIGHT) {
                i |= 1;
            }
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                i |= 2;
            }
        } else {
            i |= ((EnumFacing)state.func_177229_b((IProperty)H_FACING)).func_176746_e().func_176736_b();
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, H_FACING, OPEN, HINGE, POWERED});
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

