/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.garden;

import com.ayutaki.chinjufumod.registry.Items_Seasonal;
import com.ayutaki.chinjufumod.registry.Items_Wadeco;
import com.ayutaki.chinjufumod.registry.doors.Door_Blocks;
import com.ayutaki.chinjufumod.state.HalfState;
import com.ayutaki.chinjufumod.state.HingeState;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Kido
extends Block {
    public static final PropertyDirection H_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<HingeState> HINGE = PropertyEnum.func_177709_a((String)"hinge", HingeState.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<HalfState> HALF = PropertyEnum.func_177709_a((String)"half", HalfState.class);
    private static final double cw = 0.0625;
    protected static final AxisAlignedBB SOUTH_AABB_CLOSE = new AxisAlignedBB(0.0, 0.0, 0.421875, 1.0, 1.0, 0.578125);
    protected static final AxisAlignedBB SOUTH_AABB_OPEN_R = new AxisAlignedBB(0.0, 0.0, 0.421875, 0.15625, 1.0, 1.421875);
    protected static final AxisAlignedBB SOUTH_AABB_OPEN_L = new AxisAlignedBB(0.84375, 0.0, 0.421875, 1.0, 1.0, 1.421875);
    protected static final AxisAlignedBB EAST_AABB_CLOSE = new AxisAlignedBB(0.421875, 0.0, 0.0, 0.578125, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB_OPEN_R = new AxisAlignedBB(0.421875, 0.0, 0.84375, 1.421875, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB_OPEN_L = new AxisAlignedBB(0.421875, 0.0, 0.0, 1.421875, 1.0, 0.15625);
    protected static final AxisAlignedBB WEST_AABB_CLOSE = new AxisAlignedBB(0.421875, 0.0, 0.0, 0.578125, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB_OPEN_R = new AxisAlignedBB(-0.421875, 0.0, 0.0, 0.578125, 1.0, 0.15625);
    protected static final AxisAlignedBB WEST_AABB_OPEN_L = new AxisAlignedBB(-0.421875, 0.0, 0.84375, 0.578125, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB_CLOSE = new AxisAlignedBB(0.0, 0.0, 0.421875, 1.0, 1.0, 0.578125);
    protected static final AxisAlignedBB NORTH_AABB_OPEN_R = new AxisAlignedBB(0.84375, 0.0, -0.421875, 1.0, 1.0, 0.578125);
    protected static final AxisAlignedBB NORTH_AABB_OPEN_L = new AxisAlignedBB(0.0, 0.0, -0.421875, 0.15625, 1.0, 0.578125);

    public Kido(String name) {
        super(Material.field_151575_d);
        this.setRegistryName(new ResourceLocation("chinjufumod", name));
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
        this.func_149752_b(3.0f);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a(HINGE, (Comparable)((Object)HingeState.RIGHT)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(HALF, (Comparable)((Object)HalfState.LOWER)));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
        boolean flag = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == HingeState.LEFT;
        switch (direction) {
            case SOUTH: {
                return flag ? SOUTH_AABB_CLOSE : (flag1 ? SOUTH_AABB_OPEN_L : SOUTH_AABB_OPEN_R);
            }
            case EAST: {
                return flag ? EAST_AABB_CLOSE : (flag1 ? EAST_AABB_OPEN_L : EAST_AABB_OPEN_R);
            }
            case WEST: {
                return flag ? WEST_AABB_CLOSE : (flag1 ? WEST_AABB_OPEN_L : WEST_AABB_OPEN_R);
            }
        }
        return flag ? NORTH_AABB_CLOSE : (flag1 ? NORTH_AABB_OPEN_L : NORTH_AABB_OPEN_R);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return Kido.isOpen(Kido.combineMetadata(worldIn, pos));
    }

    public static boolean isOpen(IBlockAccess worldIn, BlockPos pos) {
        return Kido.isOpen(Kido.combineMetadata(worldIn, pos));
    }

    public static EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
        return Kido.getFacing(Kido.combineMetadata(worldIn, pos));
    }

    public static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        int i = state.func_177230_c().func_176201_c(state);
        boolean flag = Kido.isTop(i);
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        int j = downState.func_177230_c().func_176201_c(downState);
        int k = flag ? j : i;
        IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        int l = upState.func_177230_c().func_176201_c(upState);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return Kido.removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    protected static boolean isOpen(int combinedMeta) {
        return (combinedMeta & 4) != 0;
    }

    public static EnumFacing getFacing(int combinedMeta) {
        return EnumFacing.func_176731_b((int)(combinedMeta & 3)).func_176735_f();
    }

    protected static boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    protected static int removeHalfBit(int meta) {
        return meta & 7;
    }

    private SoundEvent getCloseSound() {
        return SoundEvents.field_187873_gM;
    }

    private SoundEvent getOpenSound() {
        return SoundEvents.field_187875_gN;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos pos1 = state.func_177229_b(HALF) == HalfState.LOWER ? pos : pos.func_177977_b();
        IBlockState state1 = pos.equals((Object)pos1) ? state : worldIn.func_180495_p(pos1);
        state = state1.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos1, state, 10);
        worldIn.func_175704_b(pos1, pos);
        worldIn.func_184133_a(null, pos, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == HalfState.UPPER) {
            BlockPos downPos = pos.func_177977_b();
            IBlockState downState = worldIn.func_180495_p(downPos);
            if (downState.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                downState.func_189546_a(worldIn, downPos, blockIn, fromPos);
            }
        } else {
            boolean flag1 = false;
            BlockPos upPos = pos.func_177984_a();
            IBlockState upState = worldIn.func_180495_p(upPos);
            if (upState.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (flag1) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean flag;
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(upPos);
                if (blockIn != this && (flag || blockIn.func_176223_P().func_185897_m()) && flag != (Boolean)upState.func_177229_b((IProperty)POWERED)) {
                    worldIn.func_180501_a(upPos, upState.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.func_177229_b((IProperty)OPEN)) {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
                        worldIn.func_175704_b(pos, pos);
                        worldIn.func_184133_a(null, pos, flag ? this.getOpenSound() : this.getCloseSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_185904_a().func_76222_j() && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        BlockPos downPos = pos.func_177977_b();
        BlockPos upPos = pos.func_177984_a();
        if (playerIn.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == HalfState.UPPER && worldIn.func_180495_p(downPos).func_177230_c() == this) {
            worldIn.func_175698_g(downPos);
        }
        if (state.func_177229_b(HALF) == HalfState.LOWER && worldIn.func_180495_p(upPos).func_177230_c() == this) {
            if (playerIn.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(upPos);
        }
    }

    public boolean canSilkHarvest(World worldIn, EntityPlayer playerIn, int x, int y, int z, int metadata) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        stack.add(this.takeStack(state));
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        return this.takeStack(state);
    }

    private ItemStack takeStack(IBlockState state) {
        if (state.func_177229_b(HALF) == HalfState.UPPER) {
            return new ItemStack(Items.field_190931_a);
        }
        if (state.func_177229_b(HALF) != HalfState.UPPER) {
            if (this == Door_Blocks.KIDO) {
                return new ItemStack(Items_Wadeco.KIDO_item, 1, 0);
            }
            if (this == Door_Blocks.KIDO_spruce) {
                return new ItemStack(Items_Wadeco.KIDO_item, 1, 1);
            }
            if (this == Door_Blocks.KIDO_birch) {
                return new ItemStack(Items_Wadeco.KIDO_item, 1, 2);
            }
            if (this == Door_Blocks.KIDO_jungle) {
                return new ItemStack(Items_Wadeco.KIDO_item, 1, 3);
            }
            if (this == Door_Blocks.KIDO_acacia) {
                return new ItemStack(Items_Wadeco.KIDO_item, 1, 4);
            }
            if (this == Door_Blocks.KIDO_darkoak) {
                return new ItemStack(Items_Wadeco.KIDO_item, 1, 5);
            }
            if (this == Door_Blocks.KIDO_sakura) {
                return new ItemStack(Items_Seasonal.SKIDO_item, 1, 0);
            }
            if (this == Door_Blocks.KIDO_kaede) {
                return new ItemStack(Items_Seasonal.SKIDO_item, 1, 1);
            }
            if (this == Door_Blocks.KIDO_ichoh) {
                return new ItemStack(Items_Seasonal.SKIDO_item, 1, 2);
            }
        }
        return null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == HalfState.LOWER) {
            IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
            if (upState.func_177230_c() == this) {
                state = state.func_177226_a(HINGE, upState.func_177229_b(HINGE)).func_177226_a((IProperty)POWERED, upState.func_177229_b((IProperty)POWERED));
            }
        } else {
            IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
            if (downState.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)H_FACING, downState.func_177229_b((IProperty)H_FACING)).func_177226_a((IProperty)OPEN, downState.func_177229_b((IProperty)OPEN));
            }
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177229_b(HALF) != HalfState.LOWER ? state : state.func_177226_a((IProperty)H_FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)H_FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)H_FACING))).func_177231_a(HINGE);
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)HalfState.UPPER)).func_177226_a(HINGE, (Comparable)((Object)((meta & 1) > 0 ? HingeState.LEFT : HingeState.RIGHT))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 2) > 0)) : this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)HalfState.LOWER)).func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == HalfState.UPPER) {
            i |= 8;
            if (state.func_177229_b(HINGE) == HingeState.LEFT) {
                i |= 1;
            }
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                i |= 2;
            }
        } else {
            i |= ((EnumFacing)state.func_177229_b((IProperty)H_FACING)).func_176746_e().func_176736_b();
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, H_FACING, OPEN, HINGE, POWERED});
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

