/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.crop;

import com.ayutaki.chinjufumod.blocks.wood.Suiden;
import com.ayutaki.chinjufumod.registry.Crop_Blocks;
import com.ayutaki.chinjufumod.registry.Items_Teatime;
import com.ayutaki.chinjufumod.registry.Seasonal_Blocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Rice_8
extends Block
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)8);
    protected static final double cw = 0.0625;
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, -0.0625, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.125, -0.0625, 0.125, 0.875, 0.3125, 0.875), new AxisAlignedBB(0.125, -0.0625, 0.125, 0.875, 0.4375, 0.875), new AxisAlignedBB(0.125, -0.0625, 0.125, 0.875, 0.625, 0.875), new AxisAlignedBB(0.125, -0.0625, 0.125, 0.875, 0.75, 0.875), new AxisAlignedBB(0.125, -0.0625, 0.125, 0.875, 0.9375, 0.875), new AxisAlignedBB(0.125, -0.0625, 0.125, 0.875, 0.9375, 0.875), new AxisAlignedBB(0.125, -0.0625, 0.125, 0.875, 0.9375, 0.875), new AxisAlignedBB(0.125, -0.0625, 0.125, 0.875, 0.9375, 0.875)};

    public Rice_8(String name) {
        super(Material.field_151585_k);
        this.setRegistryName(new ResourceLocation("chinjufumod", name));
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.1f);
        this.func_149752_b(0.1f);
        this.func_149713_g(0);
    }

    public int func_149738_a(World worldIn) {
        return 4500;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        worldIn.func_175684_a(pos, Crop_Blocks.RICE_8, this.func_149738_a(worldIn) + 500 * worldIn.field_73012_v.nextInt(5));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
            if (i <= 4) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)));
            }
            if (i == 5) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)));
                worldIn.func_175656_a(pos.func_177977_b(), Seasonal_Blocks.SUIDEN.func_176223_P().func_177226_a((IProperty)Suiden.WET_1_7, (Comparable)Integer.valueOf(3)));
            }
            if (i == 6 || i == 7) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)));
                worldIn.func_175656_a(pos.func_177977_b(), Seasonal_Blocks.SUIDEN.func_176223_P().func_177226_a((IProperty)Suiden.WET_1_7, (Comparable)Integer.valueOf(4)));
            }
            if (i == 8) {
                worldIn.func_175656_a(pos.func_177977_b(), Seasonal_Blocks.SUIDEN.func_176223_P().func_177226_a((IProperty)Suiden.WET_1_7, (Comparable)Integer.valueOf(4)));
            }
        }
        worldIn.func_175684_a(pos, Crop_Blocks.RICE_8, this.func_149738_a(worldIn) + 500 * rand.nextInt(5));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != Seasonal_Blocks.SUIDEN) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.func_177230_c() == Seasonal_Blocks.SUIDEN;
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 8;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return (8 - (Integer)state.func_177229_b((IProperty)AGE)) * 2;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        if (i == 6) {
            worldIn.func_175656_a(pos, this.withAge(i));
            worldIn.func_175656_a(pos.func_177977_b(), Seasonal_Blocks.SUIDEN.func_176223_P().func_177226_a((IProperty)Suiden.WET_1_7, (Comparable)Integer.valueOf(3)));
        }
        if (i == 7) {
            worldIn.func_175656_a(pos, this.withAge(i));
            worldIn.func_175656_a(pos.func_177977_b(), Seasonal_Blocks.SUIDEN.func_176223_P().func_177226_a((IProperty)Suiden.WET_1_7, (Comparable)Integer.valueOf(4)));
        }
        if (i == 8) {
            worldIn.func_175656_a(pos, this.withAge(i));
            worldIn.func_175656_a(pos.func_177977_b(), Seasonal_Blocks.SUIDEN.func_176223_P().func_177226_a((IProperty)Suiden.WET_1_7, (Comparable)Integer.valueOf(4)));
        } else {
            worldIn.func_175656_a(pos, this.withAge(i));
        }
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int i = this.getAge(state);
        return i != this.getMaxAge();
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected Item getSeed() {
        return Items_Teatime.SEEDS_RICE;
    }

    protected Item getCrop() {
        return Items_Teatime.INE;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int i;
        int k;
        Random rand;
        super.getDrops(drops, world, pos, state, 0);
        int age = this.getAge(state);
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age == 7) {
            k = 3 + fortune;
            for (i = 0; i < k; ++i) {
                if (rand.nextInt(14) > age) continue;
                drops.add((Object)new ItemStack(this.getSeed(), 1, 0));
            }
        }
        if (age == 8) {
            k = 3 + fortune;
            for (i = 0; i < k; ++i) {
                if (rand.nextInt(16) > age) continue;
                drops.add((Object)new ItemStack(this.getSeed(), this.getSeedsRand(world), 0));
            }
        }
    }

    protected int getSeedsRand(IBlockAccess world) {
        return MathHelper.func_76136_a((Random)((World)world).field_73012_v, (int)1, (int)2);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= 7 ? this.getCrop() : this.getSeed();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSeed());
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

