/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.chair;

import com.ayutaki.chinjufumod.blocks.base.BaseFacingSapo;
import com.ayutaki.chinjufumod.blocks.base.CollisionHelper;
import com.ayutaki.chinjufumod.entity.SitableEntity;
import com.ayutaki.chinjufumod.entity.helper.SittableUtil;
import com.ayutaki.chinjufumod.handler.CMEvents;
import com.ayutaki.chinjufumod.items.color.Base_ItemHake;
import com.ayutaki.chinjufumod.registry.Items_Wadeco;
import com.ayutaki.chinjufumod.registry.JPDeco_Blocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Zaisu
extends BaseFacingSapo {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.1875, 0.9375);
    private static final AxisAlignedBB CHAIR_BASE = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);
    private static final AxisAlignedBB CHAIR_BACKREST_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.125, 0.1875, 0.125, 0.1875, 0.875, 0.875);
    private static final AxisAlignedBB CHAIR_BACKREST_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.125, 0.1875, 0.125, 0.1875, 0.875, 0.875);
    private static final AxisAlignedBB CHAIR_BACKREST_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.125, 0.1875, 0.125, 0.1875, 0.875, 0.875);
    private static final AxisAlignedBB CHAIR_BACKREST_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.125, 0.1875, 0.125, 0.1875, 0.875, 0.875);

    public Zaisu(String name) {
        super(name, Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(1);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item instanceof Base_ItemHake) {
            return false;
        }
        if (SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.0)) {
            worldIn.func_175666_e(pos, (Block)this);
            CMEvents.soundKinuzure(worldIn, pos);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean t_f) {
        if (!(entityIn instanceof SitableEntity)) {
            EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
            switch (direction) {
                case SOUTH: {
                    BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_SOUTH);
                    break;
                }
                case EAST: {
                    BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_EAST);
                    break;
                }
                case WEST: {
                    BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_WEST);
                    break;
                }
                default: {
                    BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_NORTH);
                }
            }
            BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BASE);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return SittableUtil.isSomeoneSitting(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) ? 1 : 0;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canSilkHarvest(World worldIn, EntityPlayer playerIn, int x, int y, int z, int metadata) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        stack.add(this.takeStack());
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        return this.takeStack();
    }

    private ItemStack takeStack() {
        if (this == JPDeco_Blocks.ZAISU_white) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 0);
        }
        if (this == JPDeco_Blocks.ZAISU_orange) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 1);
        }
        if (this == JPDeco_Blocks.ZAISU_magenta) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 2);
        }
        if (this == JPDeco_Blocks.ZAISU_lightb) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 3);
        }
        if (this == JPDeco_Blocks.ZAISU_yellow) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 4);
        }
        if (this == JPDeco_Blocks.ZAISU_lime) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 5);
        }
        if (this == JPDeco_Blocks.ZAISU_pink) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 6);
        }
        if (this == JPDeco_Blocks.ZAISU_gray) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 7);
        }
        if (this == JPDeco_Blocks.ZAISU_lightg) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 8);
        }
        if (this == JPDeco_Blocks.ZAISU_cyan) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 9);
        }
        if (this == JPDeco_Blocks.ZAISU_purple) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 10);
        }
        if (this == JPDeco_Blocks.ZAISU_blue) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 11);
        }
        if (this == JPDeco_Blocks.ZAISU_brown) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 12);
        }
        if (this == JPDeco_Blocks.ZAISU_green) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 13);
        }
        if (this == JPDeco_Blocks.ZAISU_red) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 14);
        }
        if (this == JPDeco_Blocks.ZAISU_black) {
            return new ItemStack(Items_Wadeco.ZAISU_item, 1, 15);
        }
        return null;
    }
}

