/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.chair;

import com.ayutaki.chinjufumod.entity.helper.SittableUtil;
import com.ayutaki.chinjufumod.handler.CMEvents;
import com.ayutaki.chinjufumod.registry.Furniture_Blocks;
import com.ayutaki.chinjufumod.registry.Items_Chinjufu;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DiningChair
extends Block {
    public static final PropertyDirection H_FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<Half> HALF = PropertyEnum.func_177709_a((String)"half", Half.class);
    private static final AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5625, 0.875);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.1875);
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.125, 0.0, 0.125, 0.1875, 0.25, 0.875);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.8125, 0.0, 0.125, 0.875, 0.25, 0.875);
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.125, 0.0, 0.8125, 0.875, 0.25, 0.875);

    public DiningChair(String name) {
        super(Material.field_151575_d);
        this.setRegistryName(new ResourceLocation("chinjufumod", name));
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)H_FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HALF, (Comparable)((Object)Half.LOWER)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(HALF) == Half.LOWER && SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.375)) {
            worldIn.func_175666_e(pos, (Block)this);
            CMEvents.soundSitChair(worldIn, pos);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
        boolean flag = state.func_177229_b(HALF) == Half.LOWER;
        switch (direction) {
            case SOUTH: {
                return flag ? AABB_BASE : AABB_SOUTH;
            }
            case EAST: {
                return flag ? AABB_BASE : AABB_EAST;
            }
            case WEST: {
                return flag ? AABB_BASE : AABB_WEST;
            }
        }
        return flag ? AABB_BASE : AABB_NORTH;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean t_f) {
        boolean flag = state.func_177229_b(HALF) == Half.LOWER;
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
        switch (direction) {
            case SOUTH: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)(flag ? AABB_BASE : AABB_SOUTH));
                break;
            }
            case EAST: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)(flag ? AABB_BASE : AABB_EAST));
                break;
            }
            case WEST: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)(flag ? AABB_BASE : AABB_WEST));
                break;
            }
            default: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)(flag ? AABB_BASE : AABB_NORTH));
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == Half.UPPER) {
            BlockPos downPos = pos.func_177977_b();
            IBlockState downState = worldIn.func_180495_p(downPos);
            if (downState.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                downState.func_189546_a(worldIn, downPos, blockIn, fromPos);
            }
        } else {
            boolean flag1 = false;
            BlockPos upPos = pos.func_177984_a();
            IBlockState upState = worldIn.func_180495_p(upPos);
            if (upState.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (flag1 && !worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        BlockPos down = pos.func_177977_b();
        BlockPos up = pos.func_177984_a();
        if (playerIn.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == Half.UPPER && world.func_180495_p(down).func_177230_c() == this) {
            world.func_175698_g(down);
        }
        if (state.func_177229_b(HALF) == Half.LOWER && world.func_180495_p(up).func_177230_c() == this) {
            if (playerIn.field_71075_bZ.field_75098_d) {
                world.func_175698_g(pos);
            }
            world.func_175698_g(up);
        }
    }

    public boolean canSilkHarvest(World worldIn, EntityPlayer playerIn, int x, int y, int z, int metadata) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        stack.add(this.takeStack(state));
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        return this.takeStack(state);
    }

    private ItemStack takeStack(IBlockState state) {
        if (state.func_177229_b(HALF) == Half.UPPER) {
            return new ItemStack(Items.field_190931_a);
        }
        if (state.func_177229_b(HALF) != Half.UPPER) {
            if (this == Furniture_Blocks.DININGCHAIR) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 0);
            }
            if (this == Furniture_Blocks.DININGCHAIR_s) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 1);
            }
            if (this == Furniture_Blocks.DININGCHAIR_b) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 2);
            }
            if (this == Furniture_Blocks.DININGCHAIR_j) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 3);
            }
            if (this == Furniture_Blocks.DININGCHAIR_a) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 4);
            }
            if (this == Furniture_Blocks.DININGCHAIR_d) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 5);
            }
            if (this == Furniture_Blocks.DININGCHAIR_saku) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 6);
            }
            if (this == Furniture_Blocks.DININGCHAIR_kae) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 7);
            }
            if (this == Furniture_Blocks.DININGCHAIR_ich) {
                return new ItemStack(Items_Chinjufu.DININGCHAIR_item, 1, 8);
            }
        }
        return null;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_185904_a().func_76222_j() && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, H_FACING});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)H_FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)H_FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_177226_a((IProperty)H_FACING, (Comparable)mirror.func_185803_b((EnumFacing)state.func_177229_b((IProperty)H_FACING)));
    }

    public IBlockState func_176203_a(int meta) {
        Half half = Half.fromMetadata(meta & 1);
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta >> 1 & 3));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)half)).func_177226_a((IProperty)H_FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((Half)((Object)state.func_177229_b(HALF))).getMetadata() | ((EnumFacing)state.func_177229_b((IProperty)H_FACING)).func_176745_a() << 1;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(HALF) == Half.LOWER;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static enum Half implements IStringSerializable
    {
        LOWER("lower", 0),
        UPPER("upper", 1);

        private String name;
        private int metadata;

        private Half(String name, int metadata) {
            this.name = name;
            this.metadata = metadata;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public static Half fromMetadata(int metadata) {
            if (metadata == 1) {
                return UPPER;
            }
            return LOWER;
        }
    }
}

