/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.chair;

import com.ayutaki.chinjufumod.blocks.base.BaseFacingSapo;
import com.ayutaki.chinjufumod.blocks.base.CollisionHelper;
import com.ayutaki.chinjufumod.entity.SitableEntity;
import com.ayutaki.chinjufumod.entity.helper.SittableUtil;
import com.ayutaki.chinjufumod.handler.CMEvents;
import com.ayutaki.chinjufumod.registry.Furniture_Blocks;
import com.ayutaki.chinjufumod.registry.Items_Chinjufu;
import com.ayutaki.chinjufumod.state.TypeLR;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Bench
extends BaseFacingSapo {
    public static final PropertyEnum<TypeLR> TYPE = PropertyEnum.func_177709_a((String)"type", TypeLR.class);
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.4375, 1.0);
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.3125, 0.0, 0.0, 1.0, 0.4375, 1.0);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.6875, 0.4375, 1.0);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 0.6875);
    protected static final AxisAlignedBB CHAIR_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0);
    protected static final AxisAlignedBB CHAIR_BACKREST_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.125, 0.4375, 0.125, 0.1875, 1.0, 0.875);
    protected static final AxisAlignedBB CHAIR_BACKREST_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.125, 0.4375, 0.125, 0.1875, 1.0, 0.875);
    protected static final AxisAlignedBB CHAIR_BACKREST_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.125, 0.4375, 0.125, 0.1875, 1.0, 0.875);
    protected static final AxisAlignedBB CHAIR_BACKREST_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.125, 0.4375, 0.125, 0.1875, 1.0, 0.875);

    public Bench(String name) {
        super(name, Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(1);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.21875)) {
            worldIn.func_175666_e(pos, (Block)this);
            CMEvents.soundKinuzure(worldIn, pos);
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return SittableUtil.isSomeoneSitting(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) ? 1 : 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
        switch (direction) {
            case SOUTH: {
                return AABB_SOUTH;
            }
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
        }
        return AABB_NORTH;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean t_f) {
        if (!(entityIn instanceof SitableEntity)) {
            EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
            switch (direction) {
                case SOUTH: {
                    BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_SOUTH);
                    break;
                }
                case EAST: {
                    BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_EAST);
                    break;
                }
                case WEST: {
                    BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_WEST);
                    break;
                }
                default: {
                    BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_NORTH);
                }
            }
            BaseFacingSapo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BASE);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean right;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)H_FACING);
        IBlockState left_block = worldIn.func_180495_p(pos.func_177972_a(facing.func_176735_f()));
        IBlockState right_block = worldIn.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
        boolean left = left_block.func_177230_c() == this && ((EnumFacing)left_block.func_177229_b((IProperty)H_FACING)).equals((Object)facing);
        boolean bl = right = right_block.func_177230_c() == this && ((EnumFacing)right_block.func_177229_b((IProperty)H_FACING)).equals((Object)facing);
        if (right) {
            if (left) {
                return state.func_177226_a(TYPE, (Comparable)((Object)TypeLR.BOTH));
            }
            return state.func_177226_a(TYPE, (Comparable)((Object)TypeLR.RIGHT));
        }
        if (left) {
            if (right) {
                return state.func_177226_a(TYPE, (Comparable)((Object)TypeLR.BOTH));
            }
            return state.func_177226_a(TYPE, (Comparable)((Object)TypeLR.LEFT));
        }
        return state.func_177226_a(TYPE, (Comparable)((Object)TypeLR.DEFAULT));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{H_FACING, TYPE});
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canSilkHarvest(World worldIn, EntityPlayer playerIn, int x, int y, int z, int metadata) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        stack.add(this.takeStack(state));
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        return this.takeStack(state);
    }

    private ItemStack takeStack(IBlockState state) {
        if (this == Furniture_Blocks.BENCH) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 0);
        }
        if (this == Furniture_Blocks.BENCH_spru) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 1);
        }
        if (this == Furniture_Blocks.BENCH_bir) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 2);
        }
        if (this == Furniture_Blocks.BENCH_jun) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 3);
        }
        if (this == Furniture_Blocks.BENCH_aca) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 4);
        }
        if (this == Furniture_Blocks.BENCH_doak) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 5);
        }
        if (this == Furniture_Blocks.BENCH_saku) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 6);
        }
        if (this == Furniture_Blocks.BENCH_kae) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 7);
        }
        if (this == Furniture_Blocks.BENCH_ich) {
            return new ItemStack(Items_Chinjufu.BENCH_item, 1, 8);
        }
        return null;
    }
}

