/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.EntityExplosionContext;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class Explosion_CM
extends Explosion {
    private static final ExplosionContext EXPLOSION_DAMAGE_CALCULATOR = new ExplosionContext();
    private final boolean fire;
    private final Explosion.Mode blockInteraction;
    private final Random random = new Random();
    private final World level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity entity;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionContext damageCalculator;
    private final List<BlockPos> toBlow = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> hitPlayers = Maps.newHashMap();
    private final Vector3d position;

    @OnlyIn(value=Dist.CLIENT)
    public Explosion_CM(World worldIn, @Nullable Entity entityIn, double xIn, double yIn, double zIn, float sizeIn, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, xIn, yIn, zIn, sizeIn, false, Explosion.Mode.DESTROY, affectedPositions);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Explosion_CM(World worldIn, @Nullable Entity entityIn, double xIn, double yIn, double zIn, float sizeIn, boolean fireIn, Explosion.Mode mode, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, xIn, yIn, zIn, sizeIn, fireIn, mode);
        this.toBlow.addAll(affectedPositions);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Explosion_CM(World worldIn, @Nullable Entity entityIn, double xIn, double yIn, double zIn, float sizeIn, boolean fireIn, Explosion.Mode mode) {
        this(worldIn, entityIn, null, null, xIn, yIn, zIn, sizeIn, fireIn, mode);
    }

    public Explosion_CM(World worldIn, @Nullable Entity entityIn, @Nullable DamageSource source, @Nullable ExplosionContext context, double xIn, double yIn, double zIn, float sizeIn, boolean fireIn, Explosion.Mode mode) {
        super(worldIn, entityIn, source, context, xIn, yIn, zIn, sizeIn, fireIn, mode);
        this.level = worldIn;
        this.entity = entityIn;
        this.radius = sizeIn;
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
        this.fire = fireIn;
        this.blockInteraction = mode;
        this.damageSource = source == null ? DamageSource.func_94539_a((Explosion)this) : source;
        this.damageCalculator = context == null ? this.makeDamageCalculator(entityIn) : context;
        this.position = new Vector3d(this.x, this.y, this.z);
    }

    private ExplosionContext makeDamageCalculator(@Nullable Entity entityIn) {
        return entityIn == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityExplosionContext(entityIn);
    }

    public static float getSeenPercent(Vector3d v3d, Entity entityIn) {
        AxisAlignedBB axisalignedbb = entityIn.func_174813_aQ();
        double d0 = 1.0 / ((axisalignedbb.field_72336_d - axisalignedbb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_72337_e - axisalignedbb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.field_72334_f - axisalignedbb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = MathHelper.func_219803_d((double)f, (double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72336_d);
                        Vector3d vector3d = new Vector3d(d5 + d3, d6 = MathHelper.func_219803_d((double)f1, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72337_e), (d7 = MathHelper.func_219803_d((double)f2, (double)axisalignedbb.field_72339_c, (double)axisalignedbb.field_72334_f)) + d4);
                        if (entityIn.field_70170_p.func_217299_a(new RayTraceContext(vector3d, v3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entityIn)).func_216346_c() == RayTraceResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        FluidState fluidstate;
                        BlockPos pos = new BlockPos(d4, d6, d8);
                        BlockState state = this.level.func_180495_p(pos);
                        Optional optional = this.damageCalculator.func_230312_a_((Explosion)this, (IBlockReader)this.level, pos, state, fluidstate = this.level.func_204610_c(pos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.func_230311_a_((Explosion)this, (IBlockReader)this.level, pos, state, f)) {
                            set.add(pos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll(set);
        float f2 = this.radius * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f2 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f2 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f2 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f2 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f2 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f2 + 1.0));
        List list = this.level.func_72839_b(this.entity, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.level, (Explosion)this, (List)list, (double)f2);
        Vector3d vector3d = new Vector3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            PlayerEntity playerIn;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV() || !((d12 = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(vector3d)) / f2)) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.func_226277_ct_() - this.x) * d5 + (d7 = (entity instanceof TNTEntity ? entity.func_226278_cu_() : entity.func_226280_cw_()) - this.y) * d7 + (d9 = entity.func_226281_cx_() - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Explosion_CM.getSeenPercent(vector3d, entity);
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(this.func_199591_b(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11 * 0.8, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (playerIn = (PlayerEntity)entity).func_175149_v() || playerIn.func_184812_l_() && playerIn.field_71075_bZ.field_75100_b) continue;
            this.hitPlayers.put(playerIn, new Vector3d(d5 * d10, d7 * d10 * 0.8, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        boolean flag;
        boolean bl = flag = this.blockInteraction != Explosion.Mode.NONE;
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.toBlow, this.level.field_73012_v);
            for (BlockPos pos : this.toBlow) {
                BlockState state = this.level.func_180495_p(pos);
                if (state.isAir((IBlockReader)this.level, pos)) continue;
                BlockPos pos1 = pos.func_185334_h();
                this.level.func_217381_Z().func_76320_a("explosion_blocks");
                if (state.canDropFromExplosion((IBlockReader)this.level, pos, (Explosion)this) && this.level instanceof ServerWorld) {
                    TileEntity tileentity = state.hasTileEntity() ? this.level.func_175625_s(pos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.level).func_216023_a(this.level.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.entity);
                    if (this.blockInteraction == Explosion.Mode.DESTROY) {
                        lootcontext$builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.radius));
                    }
                    state.func_215693_a(lootcontext$builder).forEach(p_229977_2_ -> Explosion_CM.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_229977_2_, pos1));
                }
                state.onBlockExploded(this.level, pos, (Explosion)this);
                this.level.func_217381_Z().func_76319_b();
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a((World)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos pos2 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.func_180495_p(pos2).func_196958_f() || !this.level.func_180495_p(pos2.func_177977_b()).func_200015_d((IBlockReader)this.level, pos2.func_177977_b())) continue;
                this.level.func_175656_a(pos2, AbstractFireBlock.func_235326_a_((IBlockReader)this.level, (BlockPos)pos2));
            }
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> object, ItemStack stack, BlockPos pos) {
        int i = object.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)object.get(j);
            ItemStack pairStack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)pairStack, (ItemStack)stack)) continue;
            ItemStack pairStack1 = ItemEntity.func_226533_a_((ItemStack)pairStack, (ItemStack)stack, (int)16);
            object.set(j, (Object)Pair.of((Object)pairStack1, (Object)pair.getSecond()));
            if (!stack.func_190926_b()) continue;
            return;
        }
        object.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public DamageSource func_199591_b() {
        return this.damageSource;
    }

    public Map<PlayerEntity, Vector3d> func_77277_b() {
        return this.hitPlayers;
    }

    @Nullable
    public LivingEntity func_94613_c() {
        Entity entity;
        if (this.entity == null) {
            return null;
        }
        if (this.entity instanceof TNTEntity) {
            return ((TNTEntity)this.entity).func_94083_c();
        }
        if (this.entity instanceof LivingEntity) {
            return (LivingEntity)this.entity;
        }
        if (this.entity instanceof ProjectileEntity && (entity = ((ProjectileEntity)this.entity).func_234616_v_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void func_180342_d() {
        this.toBlow.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.toBlow;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getExploder() {
        return this.entity;
    }

    public static enum Mode {
        NONE,
        BREAK,
        DESTROY;

    }
}

