/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.season;

import com.ayutaki.chinjufumod.registry.Items_Seasonal;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class KusaRoof
extends Block
implements IWaterLoggable {
    public static final DirectionProperty H_FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<SlabType> TYPE = EnumProperty.func_177709_a((String)"type", SlabType.class);
    public static final BooleanProperty COR = BooleanProperty.func_177716_a((String)"cor");
    public static final BooleanProperty WATERLOGGED = BooleanProperty.func_177716_a((String)"waterlogged");
    protected static final VoxelShape AABB_BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape AABB_TOP = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public KusaRoof(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)H_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)COR, (Comparable)Boolean.valueOf(false))).func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (stack.func_190926_b() && item != Items_Seasonal.KUSATABA_RF && item != Items_Seasonal.WARATABA_RF && item != Items_Seasonal.KAYATABA_RF && playerIn.func_213453_ef()) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, 0.8f);
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)COR), 3);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = worldIn.func_180495_p(pos);
        FluidState fluid = worldIn.func_204610_c(pos);
        if (state.func_177230_c() == this) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)SlabType.DOUBLE);
        }
        BlockState blockState2 = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)H_FACING, (Comparable)context.func_195992_f().func_176734_d());
        Direction direction = context.func_196000_l();
        return direction != Direction.DOWN && (direction == Direction.UP || context.func_221532_j().field_72448_b - (double)pos.func_177956_o() <= 0.5) ? blockState2 : (BlockState)blockState2.func_206870_a(TYPE, (Comparable)SlabType.TOP);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        SlabType slabType = (SlabType)state.func_177229_b(TYPE);
        if (slabType != SlabType.DOUBLE && stack.func_77973_b() == this.func_199767_j()) {
            if (context.func_196012_c()) {
                boolean flag = context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() > 0.5;
                Direction direction = context.func_196000_l();
                if (slabType == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.func_176740_k().func_176722_c();
                }
                return direction == Direction.DOWN || !flag && direction.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)H_FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)H_FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)H_FACING)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluid) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE ? super.func_204509_a(worldIn, pos, state, fluid) : false;
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluid) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE ? super.func_204510_a(worldIn, pos, state, fluid) : false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, pos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{COR, H_FACING, TYPE, WATERLOGGED});
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SlabType slabType = (SlabType)state.func_177229_b(TYPE);
        switch (slabType) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return AABB_TOP;
            }
        }
        return AABB_BOTTOM;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.AXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 20;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag tipFlag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tips.block_tabakusa_roof").func_240699_a_(TextFormatting.GRAY));
    }
}

