/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.season;

import com.ayutaki.chinjufumod.blocks.base.CM_WaterLogged;
import com.ayutaki.chinjufumod.blocks.furnace.AbstractOvenBlock;
import com.ayutaki.chinjufumod.blocks.furnace.AbstractStoveBlock;
import com.ayutaki.chinjufumod.blocks.furnace.Irori;
import com.ayutaki.chinjufumod.blocks.kitchen.Kit_Cooktop;
import com.ayutaki.chinjufumod.blocks.season.SnowMan_Color;
import com.ayutaki.chinjufumod.registry.Items_Seasonal;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class Base_SnowMan
extends CM_WaterLogged {
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.func_177709_a((String)"half", DoubleBlockHalf.class);
    public static final DirectionProperty H_FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    protected static final VoxelShape AABB_BOT = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape AABB_TOP = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);

    public Base_SnowMan(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos downPos = pos.func_177977_b();
        BlockState downState = worldIn.func_180495_p(downPos);
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return true;
        }
        return downState.func_177230_c() instanceof Base_SnowMan;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)H_FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)H_FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)H_FACING)));
    }

    protected boolean inWater(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED);
    }

    private boolean hasHeat(IWorld worldIn, BlockPos pos) {
        for (BlockPos nearpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            BlockState nearstate = worldIn.func_180495_p(nearpos);
            Block nearblock = nearstate.func_177230_c();
            if (!(nearblock == Blocks.field_150353_l || nearblock == Blocks.field_196814_hQ || nearblock instanceof FireBlock || nearblock instanceof SoulFireBlock || nearblock instanceof CampfireBlock && (Boolean)nearstate.func_177229_b((Property)CampfireBlock.field_220101_b) != false || nearblock instanceof AbstractFurnaceBlock && (Boolean)nearstate.func_177229_b((Property)AbstractFurnaceBlock.field_220091_b) != false || nearblock instanceof AbstractOvenBlock && (Boolean)nearstate.func_177229_b((Property)AbstractOvenBlock.LIT) != false || nearblock instanceof AbstractStoveBlock && (Boolean)nearstate.func_177229_b((Property)AbstractStoveBlock.LIT) != false || nearblock instanceof Irori && (Boolean)nearstate.func_177229_b((Property)Irori.LIT) != false) && (!(nearblock instanceof Kit_Cooktop) || (Integer)nearstate.func_177229_b((Property)Kit_Cooktop.STAGE_1_3) != 2)) continue;
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos facingPos) {
        BlockState state1 = super.func_196271_a(state, facing, facingState, worldIn, pos, facingPos);
        if (!state1.isAir((IBlockReader)worldIn, pos)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (this.inWater(state, (IBlockReader)worldIn, pos) || this.hasHeat(worldIn, pos) || worldIn.func_226691_t_(pos).func_225486_c(pos) > 0.85f) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 200);
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (facing.func_176740_k() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.func_177230_c() instanceof Base_SnowMan || facingState.func_177230_c() instanceof SnowMan_Color && facingState.func_177229_b(HALF) != half) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.func_196955_c((IWorldReader)worldIn, pos) ? Blocks.field_150350_a.func_176223_P() : state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 200);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        Block downBlock = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        switch (half) {
            default: {
                if (this.inWater(state, (IBlockReader)worldIn, pos)) {
                    worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 200);
                    worldIn.func_175655_b(pos, true);
                }
                if (this.inWater(state, (IBlockReader)worldIn, pos)) break;
                if (downBlock == Blocks.field_150432_aD || downBlock == Blocks.field_150403_cj || downBlock == Blocks.field_205164_gk || downBlock == Blocks.field_196604_cC) {
                    // empty if block
                }
                if (downBlock == Blocks.field_150432_aD || downBlock == Blocks.field_150403_cj || downBlock == Blocks.field_205164_gk || downBlock == Blocks.field_196604_cC) break;
                if (this.hasHeat((IWorld)worldIn, pos)) {
                    worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 200);
                    worldIn.func_175655_b(pos, true);
                }
                if (this.hasHeat((IWorld)worldIn, pos)) break;
                if (worldIn.func_226691_t_(pos).func_225486_c(pos) > 0.85f) {
                    worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 200);
                    worldIn.func_175655_b(pos, true);
                }
                if (!(worldIn.func_226691_t_(pos).func_225486_c(pos) <= 0.85f)) break;
            }
            case UPPER: 
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? AABB_BOT : AABB_TOP;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)Items_Seasonal.SNOWMAN);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity playerIn) {
        if (!worldIn.field_72995_K) {
            if (playerIn.func_184812_l_()) {
                Base_SnowMan.breakLowerPart(worldIn, pos, state, playerIn);
            } else {
                Base_SnowMan.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)playerIn, (ItemStack)playerIn.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, playerIn);
    }

    public void func_180657_a(World worldIn, PlayerEntity playerIn, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, playerIn, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    protected static void breakLowerPart(World worldIn, BlockPos pos, BlockState state, PlayerEntity playerIn) {
        BlockPos downPos;
        BlockState downState;
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (half == DoubleBlockHalf.UPPER && (downState = worldIn.func_180495_p(downPos = pos.func_177977_b())).func_177230_c() == state.func_177230_c() && downState.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            worldIn.func_180501_a(downPos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(playerIn, 2001, downPos, Block.func_196246_j((BlockState)downState));
        }
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.SHOVEL;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }
}

