/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.gui.layered;

import com.google.common.collect.ImmutableList;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import eu.pb4.sgui.api.gui.layered.BackendSimpleGui;
import eu.pb4.sgui.api.gui.layered.Layer;
import eu.pb4.sgui.api.gui.layered.LayerView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.ApiStatus;

public class LayeredGui
implements SlotGuiInterface {
    protected final int size;
    protected final int width;
    protected final int height;
    protected final BackendSimpleGui gui;
    protected final Layer backgroundLayer;
    protected final List<LayerView> layers;
    private boolean isDirty = false;

    public LayeredGui(class_3917<?> type, class_3222 player, boolean includePlayerInventorySlots) {
        int width = GuiHelpers.getWidth(type);
        if (width != 9) {
            type = class_3917.field_17326;
        }
        this.height = GuiHelpers.getHeight(type) + (includePlayerInventorySlots ? 4 : 0);
        this.width = 9;
        this.gui = new BackendSimpleGui(type, player, includePlayerInventorySlots, this);
        this.size = this.width * this.height;
        this.backgroundLayer = new Layer(this.height, this.width);
        this.layers = new ArrayList<LayerView>();
    }

    public LayerView addLayer(Layer layer, int x, int y) {
        LayerView view = new LayerView(x, y, layer, this);
        this.layers.add(view);
        return view;
    }

    public void removeLayer(LayerView view) {
        this.layers.remove(view);
        view.remove();
        this.draw();
    }

    public ImmutableList<LayerView> getLayers() {
        return ImmutableList.copyOf(this.layers);
    }

    @Override
    public void onTick() {
        SlotGuiInterface.super.onTick();
        if (this.isDirty) {
            this.draw();
        }
    }

    protected void draw() {
        this.isDirty = false;
        this.layers.sort(Comparator.comparingInt(a -> a.zIndex));
        for (int i = 0; i < this.size; ++i) {
            GuiElementInterface element = this.backgroundLayer.elements[i];
            class_1735 slot = this.backgroundLayer.slots[i];
            for (LayerView view : this.layers) {
                GuiElementInterface viewElement = view.elements[i];
                class_1735 viewSlot = view.slots[i];
                if (viewElement != null) {
                    element = viewElement;
                    slot = null;
                    continue;
                }
                if (viewSlot == null) continue;
                element = null;
                slot = viewSlot;
            }
            if (slot == null && element == null) {
                this.gui.clearSlot(i);
                continue;
            }
            if (this.gui.getSlot(i) != element && element != null) {
                this.gui.setSlot(i, element);
                continue;
            }
            if (this.gui.getSlotRedirect(i) == slot || slot == null) continue;
            this.gui.setSlotRedirect(i, slot);
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setSlot(int index, GuiElementInterface element) {
        this.backgroundLayer.setSlot(index, element);
    }

    @Override
    public void setSlotRedirect(int index, class_1735 slot) {
        this.backgroundLayer.setSlotRedirect(index, slot);
    }

    @Override
    public int getFirstEmptySlot() {
        return this.backgroundLayer.getFirstEmptySlot();
    }

    @Override
    public void clearSlot(int index) {
        this.backgroundLayer.clearSlot(index);
    }

    @Override
    public boolean isIncludingPlayer() {
        return this.gui.isIncludingPlayer();
    }

    @Override
    public int getVirtualSize() {
        return this.gui.getVirtualSize();
    }

    @Override
    public GuiElementInterface getSlot(int index) {
        return this.backgroundLayer.getSlot(index);
    }

    @Override
    public class_1735 getSlotRedirect(int index) {
        return this.backgroundLayer.getSlotRedirect(index);
    }

    @Override
    public boolean isRedirectingSlots() {
        return this.gui.isRedirectingSlots();
    }

    @Override
    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        return true;
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    public boolean click(int index, ClickType type, class_1713 action) {
        return false;
    }

    @Override
    public class_2561 getTitle() {
        return this.gui.getTitle();
    }

    @Override
    public void setTitle(class_2561 title) {
        this.gui.setTitle(title);
    }

    @Override
    public class_3917<?> getType() {
        return this.gui.getType();
    }

    @Override
    public boolean isOpen() {
        return this.gui.isOpen();
    }

    @Override
    public boolean open() {
        if (this.isDirty) {
            this.draw();
        }
        return this.gui.open();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void close(boolean screenHandlerIsClosed) {
        this.gui.close(screenHandlerIsClosed);
    }

    @Override
    public boolean getLockPlayerInventory() {
        return this.gui.getLockPlayerInventory();
    }

    @Override
    public void setLockPlayerInventory(boolean value) {
        this.gui.setLockPlayerInventory(value);
    }

    @Override
    public boolean getAutoUpdate() {
        return this.gui.getAutoUpdate();
    }

    @Override
    public void setAutoUpdate(boolean value) {
        this.gui.setAutoUpdate(value);
    }

    @Override
    public class_3222 getPlayer() {
        return this.gui.getPlayer();
    }

    @Override
    public int getSyncId() {
        return this.gui.getSyncId();
    }

    public void markDirty() {
        this.isDirty = true;
    }
}

