/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.gui;

import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.virtual.merchant.VirtualMerchant;
import eu.pb4.sgui.virtual.merchant.VirtualMerchantScreenHandler;
import eu.pb4.sgui.virtual.merchant.VirtualTradeOutputSlot;
import java.util.Arrays;
import java.util.OptionalInt;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1725;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public class MerchantGui
extends SimpleGui {
    protected final VirtualMerchant merchant;
    protected final class_1725 merchantInventory;

    public MerchantGui(class_3222 player, boolean includePlayerInventorySlots) {
        super(class_3917.field_17340, player, includePlayerInventorySlots);
        this.merchant = new VirtualMerchant((class_1657)player);
        this.merchantInventory = new class_1725((class_1915)this.merchant);
        this.setTitle(class_2585.field_24366);
        this.setSlotRedirect(0, new class_1735((class_1263)this.merchantInventory, 0, 0, 0));
        this.setSlotRedirect(1, new class_1735((class_1263)this.merchantInventory, 1, 0, 0));
        this.setSlotRedirect(2, (class_1735)new VirtualTradeOutputSlot((class_1657)player, this.merchant, this.merchantInventory, 2, 0, 0));
    }

    public void addTrade(class_1914 trade) {
        this.merchant.method_8264().add((Object)trade);
        if (this.open && this.autoUpdate) {
            this.sendUpdate();
        }
    }

    public void setTrade(int index, class_1914 trade) {
        this.merchant.method_8264().add(index, (Object)trade);
        if (this.open && this.autoUpdate) {
            this.sendUpdate();
        }
    }

    public void setIsLeveled(boolean isLeveled) {
        this.merchant.setLeveled(isLeveled);
        if (this.open && this.autoUpdate) {
            this.sendUpdate();
        }
    }

    public void setLevel(VillagerLevel level) {
        this.merchant.setLevel(level.ordinal());
        if (this.open && this.autoUpdate) {
            this.sendUpdate();
        }
    }

    public VillagerLevel getLevel() {
        return VillagerLevel.values()[this.merchant.getLevel()];
    }

    public void setExperience(int experience) {
        this.merchant.method_19271(experience);
        if (this.open && this.autoUpdate) {
            this.sendUpdate();
        }
    }

    public int getExperience() {
        return this.merchant.method_19269();
    }

    public void onSelectTrade(class_1914 offer) {
    }

    public class_1914 getSelectedTrade() {
        return this.merchantInventory.method_7642();
    }

    public boolean onTrade(class_1914 offer) {
        return true;
    }

    public void onSuggestSell(class_1914 offer) {
    }

    public int getOfferIndex(class_1914 offer) {
        for (int i = 0; i < this.merchant.method_8264().size(); ++i) {
            if (!MerchantGui.areTradeOffersEqualIgnoreUses((class_1914)this.merchant.method_8264().get(i), offer)) continue;
            return i;
        }
        return -1;
    }

    public void sendUpdate() {
        class_1916 tradeOfferList = this.merchant.method_8264();
        if (!tradeOfferList.isEmpty()) {
            this.player.method_17354(this.syncId, tradeOfferList, this.merchant.getLevel(), this.merchant.method_19269(), this.merchant.method_19270(), this.merchant.method_20708());
        }
    }

    @Override
    protected boolean sendGui() {
        this.reOpen = true;
        OptionalInt opSyncId = this.player.method_17355((class_3908)new class_747((syncId, playerInventory, playerx) -> new VirtualMerchantScreenHandler(syncId, this.player, this.merchant, this, this.merchantInventory), this.getTitle()));
        if (opSyncId.isPresent()) {
            this.syncId = opSyncId.getAsInt();
            this.screenHandler = (VirtualMerchantScreenHandler)this.player.field_7512;
            class_1916 tradeOfferList = this.merchant.method_8264();
            if (!tradeOfferList.isEmpty()) {
                this.player.method_17354(opSyncId.getAsInt(), tradeOfferList, this.merchant.getLevel(), this.merchant.method_19269(), this.merchant.method_19270(), this.merchant.method_20708());
            }
            this.reOpen = false;
            return true;
        }
        this.reOpen = false;
        return false;
    }

    public static boolean areTradeOffersEqualIgnoreUses(@Nullable class_1914 x, @Nullable class_1914 y) {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.method_8256() == y.method_8256() && x.method_21725() == y.method_21725() && x.method_8248() == y.method_8248() && x.method_19279() == y.method_19279() && x.method_19277() == y.method_19277() && class_1799.method_7973((class_1799)x.method_8250(), (class_1799)y.method_8250()) && class_1799.method_7973((class_1799)x.method_8246(), (class_1799)y.method_8246()) && class_1799.method_7973((class_1799)x.method_8247(), (class_1799)y.method_8247());
    }

    public static enum VillagerLevel {
        NONE(-1),
        NOVICE(0),
        APPRENTICE(10),
        JOURNEYMAN(70),
        EXPERT(150),
        MASTER(250);

        private static final VillagerLevel[] xpSorted;
        public final int startXp;

        private VillagerLevel(int startXp) {
            this.startXp = startXp;
        }

        public static VillagerLevel fromId(int id) {
            return VillagerLevel.values()[id];
        }

        public static VillagerLevel fromXp(int xp) {
            for (VillagerLevel value : xpSorted) {
                if (xp < value.startXp) continue;
                return value;
            }
            return NONE;
        }

        static {
            xpSorted = (VillagerLevel[])Arrays.stream(VillagerLevel.values()).sorted((x, y) -> Integer.compare(y.startXp, x.startXp)).toArray(VillagerLevel[]::new);
        }
    }
}

