/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.gui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.BaseSlotGui;
import eu.pb4.sgui.virtual.hotbar.HotbarScreenHandler;
import eu.pb4.sgui.virtual.inventory.VirtualSlot;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2735;
import net.minecraft.class_2846;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class HotbarGui
extends BaseSlotGui {
    public static final int SIZE = 46;
    public static final int[] VANILLA_HOTBAR_SLOT_IDS = HotbarGui.createArrayFromTo(36, 44);
    public static final int[] VANILLA_BACKPACK_SLOT_IDS = HotbarGui.createArrayFromTo(9, 35);
    public static final int[] VANILLA_ARMOR_SLOT_IDS = HotbarGui.createArrayFromTo(5, 8);
    public static final int VANILLA_OFFHAND_SLOT_ID = 45;
    public static final int[] VANILLA_CRAFTING_IDS = new int[]{1, 2, 3, 4, 0};
    public static final int[] GUI_TO_VANILLA_IDS = HotbarGui.mergeArrays(VANILLA_HOTBAR_SLOT_IDS, {45}, VANILLA_BACKPACK_SLOT_IDS, VANILLA_ARMOR_SLOT_IDS, VANILLA_CRAFTING_IDS);
    public static final int[] VANILLA_TO_GUI_IDS = HotbarGui.rotateArray(GUI_TO_VANILLA_IDS);
    protected int selectedSlot = 0;
    protected boolean hasRedirects = false;
    private HotbarScreenHandler screenHandler;
    private int clicksPerTick;

    public HotbarGui(class_3222 player) {
        super(player, 46);
    }

    private static int[] rotateArray(int[] input) {
        int[] array = new int[input.length];
        for (int i = 0; i < array.length; ++i) {
            array[input[i]] = i;
        }
        return array;
    }

    private static int[] createArrayFromTo(int first, int last) {
        IntArrayList list = new IntArrayList(last - first);
        for (int i = first; i <= last; ++i) {
            list.add(i);
        }
        return list.toIntArray();
    }

    private static int[] mergeArrays(int[] ... idArrays) {
        IntArrayList list = new IntArrayList(46);
        int[][] nArray = idArrays;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] array;
            for (int i2 : array = nArray[i]) {
                list.add(i2);
            }
        }
        return list.toIntArray();
    }

    @Override
    public void setSlot(int index, GuiElementInterface element) {
        super.setSlot(index, element);
        if (this.open && this.autoUpdate && this.screenHandler != null) {
            this.screenHandler.setSlot(GUI_TO_VANILLA_IDS[index], new VirtualSlot(this.screenHandler.inventory, index, 0, 0));
        }
    }

    @Override
    public void setSlotRedirect(int index, class_1735 slot) {
        super.setSlotRedirect(index, slot);
        if (this.open && this.autoUpdate && this.screenHandler != null) {
            this.screenHandler.setSlot(GUI_TO_VANILLA_IDS[index], slot);
        }
        this.hasRedirects = true;
    }

    @Override
    public void clearSlot(int index) {
        super.clearSlot(index);
        if (this.open && this.autoUpdate && this.screenHandler != null) {
            this.screenHandler.setSlot(GUI_TO_VANILLA_IDS[index], new VirtualSlot(this.screenHandler.inventory, index, 0, 0));
        }
    }

    @Override
    public boolean click(int index, ClickType type, class_1713 action) {
        return super.click(VANILLA_TO_GUI_IDS[index], type, action);
    }

    @Override
    public boolean open() {
        if (this.player.method_14239() || this.open) {
            return false;
        }
        this.open = true;
        this.onOpen();
        if (this.player.field_7512 != this.player.field_7498 && this.player.field_7512 != this.screenHandler) {
            this.player.method_7346();
        }
        if (this.screenHandler == null) {
            this.screenHandler = new HotbarScreenHandler(null, 0, this, (class_1657)this.player);
        }
        this.player.field_7512 = this.screenHandler;
        GuiHelpers.sendPlayerScreenHandler(this.player);
        this.player.field_13987.method_14364((class_2596)new class_2735(this.selectedSlot));
        return true;
    }

    public boolean onSelectedSlotChange(int slot) {
        this.setSelectedSlot(slot);
        return true;
    }

    public void onClickItem() {
        if (this.player.method_5715()) {
            this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_RIGHT_SHIFT, class_1713.field_7794);
        } else {
            this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_RIGHT, class_1713.field_7790);
        }
    }

    public boolean onHandSwing() {
        if (this.player.method_5715()) {
            this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_LEFT_SHIFT, class_1713.field_7794);
        } else {
            this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_LEFT, class_1713.field_7790);
        }
        return false;
    }

    public boolean onClickBlock(class_3965 hitResult) {
        if (this.player.method_5715()) {
            this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_RIGHT_SHIFT, class_1713.field_7794);
        } else {
            this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_RIGHT, class_1713.field_7790);
        }
        return false;
    }

    public boolean onPlayerAction(class_2846.class_2847 action, class_2350 direction) {
        switch (action) {
            case field_12975: {
                this.tickLimitedClick(this.selectedSlot, ClickType.DROP, class_1713.field_7795);
                break;
            }
            case field_12970: {
                this.tickLimitedClick(this.selectedSlot, ClickType.CTRL_DROP, class_1713.field_7795);
                break;
            }
            case field_12973: {
                if (this.player.method_5715()) {
                    this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_LEFT_SHIFT, class_1713.field_7794);
                    break;
                }
                this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_LEFT, class_1713.field_7790);
                break;
            }
            case field_12969: {
                this.tickLimitedClick(this.selectedSlot, ClickType.OFFHAND_SWAP, class_1713.field_7791);
            }
        }
        return false;
    }

    public boolean onClickEntity(int entityId, EntityInteraction type, boolean isSneaking, @Nullable class_243 interactionPos) {
        if (type == EntityInteraction.ATTACK) {
            if (isSneaking) {
                this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_LEFT_SHIFT, class_1713.field_7794);
            } else {
                this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_LEFT, class_1713.field_7790);
            }
        } else if (isSneaking) {
            this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_RIGHT_SHIFT, class_1713.field_7794);
        } else {
            this.tickLimitedClick(this.selectedSlot, ClickType.MOUSE_RIGHT, class_1713.field_7790);
        }
        return false;
    }

    public void setSelectedSlot(int value) {
        this.selectedSlot = class_3532.method_15340((int)value, (int)0, (int)8);
        if (this.open) {
            this.player.field_13987.method_14364((class_2596)new class_2735(this.selectedSlot));
        }
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @ApiStatus.Internal
    private void tickLimitedClick(int selectedSlot, ClickType type, class_1713 actionType) {
        if (this.clicksPerTick == 0) {
            this.click(GUI_TO_VANILLA_IDS[selectedSlot], type, actionType);
        }
        ++this.clicksPerTick;
    }

    @Override
    public void onTick() {
        this.clicksPerTick = 0;
        super.onTick();
    }

    @Override
    public void close(boolean screenHandlerIsClosed) {
        if (this.open && !this.reOpen) {
            this.open = false;
            this.reOpen = false;
            if (!screenHandlerIsClosed && this.player.field_7512 == this.screenHandler) {
                this.player.method_7346();
            }
            this.onClose();
            this.player.field_13987.method_14364((class_2596)new class_2735(this.player.method_31548().field_7545));
            GuiHelpers.sendPlayerInventory(this.getPlayer());
        } else {
            this.reOpen = false;
        }
    }

    @Override
    public boolean isIncludingPlayer() {
        return true;
    }

    @Override
    public int getVirtualSize() {
        return 46;
    }

    @Override
    public boolean isRedirectingSlots() {
        return this.hasRedirects;
    }

    @Override
    public int getSyncId() {
        return 0;
    }

    @Override
    public int getSize() {
        return 46;
    }

    @Override
    @Deprecated
    public int getHeight() {
        return 4;
    }

    @Override
    @Deprecated
    public int getWidth() {
        return 9;
    }

    @Override
    @Deprecated
    public class_3917<?> getType() {
        return null;
    }

    @Override
    @Deprecated
    public boolean getLockPlayerInventory() {
        return true;
    }

    @Override
    @Deprecated
    public void setLockPlayerInventory(boolean value) {
    }

    @Override
    @Deprecated
    @Nullable
    public class_2561 getTitle() {
        return null;
    }

    @Override
    @Deprecated
    public void setTitle(class_2561 title) {
    }

    public static enum EntityInteraction {
        INTERACT,
        ATTACK,
        INTERACT_AT;

    }
}

